/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.DefaultProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.util.ValueAnnotationProcessor;
import com.navercorp.pinpoint.common.util.PropertyUtils;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProfilerConfigLoader {
    private static final CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(DefaultProfilerConfig.class.getName());

    public static ProfilerConfig load(InputStream inputStream) {
        Properties properties = ProfilerConfigLoader.loadProperties(inputStream);
        return ProfilerConfigLoader.load(properties);
    }

    private static Properties loadProperties(InputStream inputStream) {
        try {
            return PropertyUtils.loadProperty((InputStream)inputStream);
        }
        catch (IOException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("IO error. Error:" + ex.getMessage(), (Throwable)ex);
            }
            throw new RuntimeException("IO error. Error:" + ex.getMessage(), ex);
        }
    }

    public static ProfilerConfig load(Properties properties) {
        DefaultProfilerConfig profilerConfig = new DefaultProfilerConfig(properties);
        ProfilerConfigLoader.loadPropertyValues(profilerConfig, properties);
        return profilerConfig;
    }

    private static void loadPropertyValues(ProfilerConfig profilerConfig, Properties properties) {
        ValueAnnotationProcessor processor = new ValueAnnotationProcessor();
        processor.process((Object)profilerConfig, properties);
    }
}

