/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.common;

public enum ClientType {
    PUB(1, "Client for publishing"),
    SUB(2, "Client for subscribing");

    private Integer type;
    private String desc;

    private ClientType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ClientType get(Integer type) {
        if (ClientType.PUB.type.intValue() == type.intValue()) {
            return PUB;
        }
        if (ClientType.SUB.type.intValue() == type.intValue()) {
            return SUB;
        }
        return null;
    }

    public static boolean contains(Integer clientType) {
        boolean flag = false;
        for (ClientType ct : ClientType.values()) {
            if (ct.type.intValue() != clientType.intValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

