/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;

public final class PrometheusTcpExporter {
    public static void export(String meterName, TcpSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)meterName);
        meter.doubleValueObserverBuilder("eventmesh.tcp.retry.queue.size").setDescription("get size of retry queue.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getRetrySize(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.server.tps").setDescription("get tps of client to eventMesh.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getClient2eventMeshTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.mq.provider.tps").setDescription("get tps of eventMesh to mq.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getEventMesh2mqTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.mq.consumer.tps").setDescription("get tps of mq to eventMesh.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getMq2eventMeshTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.client.tps").setDescription("get tps of eventMesh to client.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getEventMesh2clientTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.all.tps").setDescription("get all TPS.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getAllTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.connection.num").setDescription("EventMeshTcpConnectionHandler.connections.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getAllConnections(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.tcp.sub.topic.num").setDescription("get sub topic num.").setUnit("TCP").setUpdater(result -> result.observe((double)summaryMetrics.getSubTopicNum(), Labels.empty())).build();
    }

    private PrometheusTcpExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

