/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus;

import io.opentelemetry.exporter.prometheus.PrometheusCollector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.GrpcSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;
import org.apache.eventmesh.metrics.prometheus.config.PrometheusConfiguration;
import org.apache.eventmesh.metrics.prometheus.metrics.PrometheusGrpcExporter;
import org.apache.eventmesh.metrics.prometheus.metrics.PrometheusHttpExporter;
import org.apache.eventmesh.metrics.prometheus.metrics.PrometheusTcpExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsRegistry
implements MetricsRegistry {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsRegistry.class);
    private volatile HTTPServer prometheusHttpServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.prometheusHttpServer != null) return;
        Class<PrometheusMetricsRegistry> clazz = PrometheusMetricsRegistry.class;
        synchronized (PrometheusMetricsRegistry.class) {
            if (this.prometheusHttpServer != null) return;
            SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().buildAndRegisterGlobal();
            PrometheusCollector.builder().setMetricProducer((MetricProducer)sdkMeterProvider).buildAndRegister();
            int port = PrometheusConfiguration.getEventMeshPrometheusPort();
            try {
                this.prometheusHttpServer = new HTTPServer(port, true);
            }
            catch (IOException e) {
                log.error("failed to start prometheus server, port: {} due to {}", (Object)port, (Object)e.getMessage());
            }
            return;
        }
    }

    public void showdown() {
        if (this.prometheusHttpServer != null) {
            this.prometheusHttpServer.stop();
        }
    }

    public void register(Metric metric) {
        if (metric == null) {
            throw new IllegalArgumentException("Metric cannot be null");
        }
        if (metric instanceof HttpSummaryMetrics) {
            PrometheusHttpExporter.export("apache-eventmesh", (HttpSummaryMetrics)metric);
        }
        if (metric instanceof TcpSummaryMetrics) {
            PrometheusTcpExporter.export("apache-eventmesh", (TcpSummaryMetrics)metric);
        }
        if (metric instanceof GrpcSummaryMetrics) {
            PrometheusGrpcExporter.export("apache-eventmesh", (GrpcSummaryMetrics)metric);
        }
    }

    public void unRegister(Metric metric) {
    }
}

