/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.client;

import io.cloudevents.CloudEvent;
import io.pravega.client.stream.EventRead;
import io.pravega.client.stream.EventStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.connector.pravega.client.PravegaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeTask
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SubscribeTask.class);
    private final EventStreamReader<byte[]> reader;
    private final EventListener listener;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicBoolean continueRead = new AtomicBoolean(true);

    public SubscribeTask(String name, EventStreamReader<byte[]> reader, EventListener listener) {
        super(name);
        this.reader = reader;
        this.listener = listener;
    }

    @Override
    public void run() {
        CloudEvent cloudEvent = null;
        while (this.running.get()) {
            if (this.continueRead.get()) {
                byte[] eventByteArray;
                EventRead event = this.reader.readNextEvent(2000L);
                if (event == null || (eventByteArray = (byte[])event.getEvent()) == null) continue;
                PravegaEvent pravegaEvent = PravegaEvent.getFromByteArray(eventByteArray);
                cloudEvent = pravegaEvent.convertToCloudEvent();
                this.listener.consume(cloudEvent, (AsyncConsumeContext)new PravegaEventMeshAsyncConsumeContext());
                continue;
            }
            this.listener.consume(cloudEvent, (AsyncConsumeContext)new PravegaEventMeshAsyncConsumeContext());
        }
    }

    public void stopRead() {
        this.running.compareAndSet(true, false);
    }

    private class PravegaEventMeshAsyncConsumeContext
    extends EventMeshAsyncConsumeContext {
        private PravegaEventMeshAsyncConsumeContext() {
        }

        public void commit(EventMeshAction action) {
            switch (action) {
                case CommitMessage: 
                case ReconsumeLater: {
                    SubscribeTask.this.continueRead.set(false);
                    break;
                }
                case ManualAck: {
                    SubscribeTask.this.continueRead.set(true);
                    break;
                }
            }
        }
    }
}

