/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.client;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.pravega.exception.PravegaConnectorException;

public class PravegaEvent
implements Serializable {
    private static final long serialVersionUID = 0L;
    private SpecVersion version;
    private String topic;
    private String data;
    private Map<String, String> extensions = new HashMap<String, String>();
    private long createTimestamp;

    public static byte[] toByteArray(PravegaEvent pravegaEvent) {
        return JsonUtils.serialize((Object)pravegaEvent).getBytes(StandardCharsets.UTF_8);
    }

    public static PravegaEvent getFromByteArray(byte[] body) {
        return (PravegaEvent)JsonUtils.deserialize((String)new String(body, StandardCharsets.UTF_8), PravegaEvent.class);
    }

    public CloudEvent convertToCloudEvent() {
        CloudEventBuilder builder;
        switch (this.version) {
            case V03: {
                builder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                break;
            }
            case V1: {
                builder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                break;
            }
            default: {
                throw new PravegaConnectorException(String.format("CloudEvent version %s does not support.", this.version));
            }
        }
        builder.withData(this.data.getBytes(StandardCharsets.UTF_8)).withId(this.extensions.remove("id")).withSource(URI.create(this.extensions.remove("source"))).withType(this.extensions.remove("type")).withDataContentType(this.extensions.remove("datacontenttype")).withSubject(this.extensions.remove("subject"));
        this.extensions.forEach((arg_0, arg_1) -> ((io.cloudevents.core.builder.CloudEventBuilder)builder).withExtension(arg_0, arg_1));
        return builder.build();
    }

    public SpecVersion getVersion() {
        return this.version;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setVersion(SpecVersion version) {
        this.version = version;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PravegaEvent)) {
            return false;
        }
        PravegaEvent other = (PravegaEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTimestamp() != other.getCreateTimestamp()) {
            return false;
        }
        SpecVersion this$version = this.getVersion();
        SpecVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, String> this$extensions = this.getExtensions();
        Map<String, String> other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PravegaEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTimestamp = this.getCreateTimestamp();
        result = result * 59 + (int)($createTimestamp >>> 32 ^ $createTimestamp);
        SpecVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    public String toString() {
        return "PravegaEvent(version=" + this.getVersion() + ", topic=" + this.getTopic() + ", data=" + this.getData() + ", extensions=" + this.getExtensions() + ", createTimestamp=" + this.getCreateTimestamp() + ")";
    }
}

