/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.client;

import io.cloudevents.CloudEvent;
import io.pravega.client.ClientConfig;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.admin.StreamManager;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.ReaderConfig;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.ByteArraySerializer;
import io.pravega.shared.NameUtils;
import io.pravega.shared.security.auth.Credentials;
import io.pravega.shared.security.auth.DefaultCredentials;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.connector.pravega.client.PravegaCloudEventWriter;
import org.apache.eventmesh.connector.pravega.client.PravegaEvent;
import org.apache.eventmesh.connector.pravega.client.SubscribeTask;
import org.apache.eventmesh.connector.pravega.config.PravegaConnectorConfig;
import org.apache.eventmesh.connector.pravega.exception.PravegaConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaClient {
    private static final Logger log = LoggerFactory.getLogger(PravegaClient.class);
    private final PravegaConnectorConfig config;
    private final StreamManager streamManager;
    private final EventStreamClientFactory clientFactory;
    private final ReaderGroupManager readerGroupManager;
    private final Map<String, EventStreamWriter<byte[]>> writerMap = new ConcurrentHashMap<String, EventStreamWriter<byte[]>>();
    private final Map<String, SubscribeTask> subscribeTaskMap = new ConcurrentHashMap<String, SubscribeTask>();
    private static PravegaClient instance;

    private PravegaClient(PravegaConnectorConfig config) {
        this.config = config;
        this.streamManager = StreamManager.create((URI)config.getControllerURI());
        ClientConfig.ClientConfigBuilder clientConfigBuilder = ClientConfig.builder().controllerURI(config.getControllerURI());
        if (config.isAuthEnabled()) {
            clientConfigBuilder.credentials((Credentials)new DefaultCredentials(config.getPassword(), config.getUsername()));
        }
        if (config.isTlsEnable()) {
            clientConfigBuilder.trustStore(config.getTruststore()).validateHostName(false);
        }
        ClientConfig clientConfig = clientConfigBuilder.build();
        this.clientFactory = EventStreamClientFactory.withScope((String)config.getScope(), (ClientConfig)clientConfig);
        this.readerGroupManager = ReaderGroupManager.withScope((String)config.getScope(), (ClientConfig)clientConfig);
    }

    public static PravegaClient getInstance() {
        if (instance == null) {
            instance = new PravegaClient(PravegaConnectorConfig.getInstance());
        }
        return instance;
    }

    protected static PravegaClient getNewInstance(PravegaConnectorConfig config) {
        return new PravegaClient(config);
    }

    public void start() {
        if (this.createScope()) {
            log.info("Create Pravega scope[{}] success.", (Object)PravegaConnectorConfig.getInstance().getScope());
        } else {
            log.info("Pravega scope[{}] has already been created.", (Object)PravegaConnectorConfig.getInstance().getScope());
        }
    }

    public void shutdown() {
        this.subscribeTaskMap.forEach((topic, task) -> task.stopRead());
        this.subscribeTaskMap.clear();
        this.writerMap.forEach((topic, writer) -> writer.close());
        this.writerMap.clear();
        this.readerGroupManager.close();
        this.clientFactory.close();
        this.streamManager.close();
    }

    public SendResult publish(String topic, CloudEvent cloudEvent) {
        if (!this.createStream(topic)) {
            log.debug("stream[{}] has already been created.", (Object)topic);
        }
        EventStreamWriter writer = this.writerMap.computeIfAbsent(topic, k -> this.createWrite(topic));
        PravegaCloudEventWriter cloudEventWriter = new PravegaCloudEventWriter(topic);
        PravegaEvent pravegaEvent = (PravegaEvent)cloudEventWriter.writeBinary(cloudEvent);
        try {
            writer.writeEvent((Object)PravegaEvent.toByteArray(pravegaEvent)).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error(String.format("Write topic[%s] fail.", topic), (Throwable)e);
            throw new PravegaConnectorException(String.format("Write topic[%s] fail.", topic));
        }
        SendResult sendResult = new SendResult();
        sendResult.setTopic(topic);
        sendResult.setMessageId("-1");
        return sendResult;
    }

    public boolean subscribe(String topic, boolean isBroadcast, String consumerGroup, String instanceName, EventListener listener) {
        if (this.subscribeTaskMap.containsKey(topic)) {
            return true;
        }
        String readerGroupName = this.buildReaderGroupName(isBroadcast, consumerGroup, topic);
        this.createReaderGroup(topic, readerGroupName);
        String readerId = this.buildReaderId(instanceName);
        EventStreamReader<byte[]> reader = this.createReader(readerId, readerGroupName);
        SubscribeTask subscribeTask = new SubscribeTask(topic, reader, listener);
        subscribeTask.start();
        this.subscribeTaskMap.put(topic, subscribeTask);
        return true;
    }

    public boolean unsubscribe(String topic, boolean isBroadcast, String consumerGroup) {
        if (!this.subscribeTaskMap.containsKey(topic)) {
            return true;
        }
        if (!isBroadcast) {
            this.deleteReaderGroup(this.buildReaderGroupName(false, consumerGroup, topic));
        }
        this.subscribeTaskMap.remove(topic).stopRead();
        return true;
    }

    public boolean checkTopicExist(String topic) {
        return this.streamManager.checkStreamExists(this.config.getScope(), topic);
    }

    private boolean createScope() {
        return this.streamManager.createScope(this.config.getScope());
    }

    private boolean createStream(String topic) {
        StreamConfiguration streamConfiguration = StreamConfiguration.builder().build();
        return this.streamManager.createStream(this.config.getScope(), topic, streamConfiguration);
    }

    private EventStreamWriter<byte[]> createWrite(String topic) {
        return this.clientFactory.createEventWriter(topic, (Serializer)new ByteArraySerializer(), EventWriterConfig.builder().build());
    }

    private String buildReaderGroupName(boolean isBroadcast, String consumerGroup, String topic) {
        if (isBroadcast) {
            return UUID.randomUUID().toString();
        }
        return String.format("%s-%s", consumerGroup, topic);
    }

    private String buildReaderId(String instanceName) {
        return String.format("%s-reader", instanceName).replaceAll("\\(", "-").replaceAll("\\)", "-");
    }

    private void createReaderGroup(String topic, String readerGroupName) {
        if (!this.checkTopicExist(topic)) {
            this.createStream(topic);
        }
        ReaderGroupConfig readerGroupConfig = ReaderGroupConfig.builder().stream(NameUtils.getScopedStreamName((String)this.config.getScope(), (String)topic)).retentionType(ReaderGroupConfig.StreamDataRetention.AUTOMATIC_RELEASE_AT_LAST_CHECKPOINT).build();
        this.readerGroupManager.createReaderGroup(readerGroupName, readerGroupConfig);
    }

    private void deleteReaderGroup(String readerGroup) {
        this.readerGroupManager.deleteReaderGroup(readerGroup);
    }

    private EventStreamReader<byte[]> createReader(String readerId, String readerGroup) {
        return this.clientFactory.createReader(readerId, readerGroup, (Serializer)new ByteArraySerializer(), ReaderConfig.builder().build());
    }

    protected StreamManager getStreamManager() {
        return this.streamManager;
    }

    protected EventStreamClientFactory getClientFactory() {
        return this.clientFactory;
    }

    protected ReaderGroupManager getReaderGroupManager() {
        return this.readerGroupManager;
    }

    public Map<String, EventStreamWriter<byte[]>> getWriterMap() {
        return this.writerMap;
    }

    protected Map<String, SubscribeTask> getSubscribeTaskMap() {
        return this.subscribeTaskMap;
    }
}

