/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.connector.pravega.client.PravegaClient;
import org.apache.eventmesh.connector.pravega.exception.PravegaConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaProducerImpl
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(PravegaProducerImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private PravegaClient client;

    public void init(Properties properties) throws Exception {
        this.client = PravegaClient.getInstance();
    }

    public void start() {
        this.started.compareAndSet(false, true);
    }

    public void shutdown() {
        this.started.compareAndSet(true, false);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.started.get();
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        try {
            SendResult sendResult = this.client.publish(cloudEvent.getSubject(), cloudEvent);
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception e) {
            log.error("send message error, topic: {}", (Object)cloudEvent.getSubject());
            OnExceptionContext onExceptionContext = OnExceptionContext.builder().messageId("-1").topic(cloudEvent.getSubject()).exception(new ConnectorRuntimeException((Throwable)e)).build();
            sendCallback.onException(onExceptionContext);
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        this.client.publish(cloudEvent.getSubject(), cloudEvent);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void checkTopicExist(String topic) throws Exception {
        if (!this.client.checkTopicExist(topic)) {
            throw new PravegaConnectorException(String.format("topic:%s is not exist", topic));
        }
    }

    public void setExtFields() {
    }
}

