/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExecutionThreadStateChangeEventHandler<S extends PinpointSocket>
implements StateChangeEventListener<S> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final StateChangeEventListener handler;
    private final Executor executor;

    public ExecutionThreadStateChangeEventHandler(StateChangeEventListener handler, Executor executor) {
        this.handler = handler;
        this.executor = executor;
    }

    @Override
    public void stateUpdated(S pinpointSocket, SocketStateCode updatedStateCode) {
        Execution execution = new Execution(this, pinpointSocket, updatedStateCode);
        this.executor.execute(execution);
    }

    private static class Execution
    implements Runnable {
        private final S pinpointSocket;
        private final SocketStateCode stateCode;
        final /* synthetic */ ExecutionThreadStateChangeEventHandler this$0;

        public Execution(S pinpointSocket, SocketStateCode stateCode) {
            this.this$0 = var1_1;
            this.pinpointSocket = pinpointSocket;
            this.stateCode = stateCode;
        }

        @Override
        public void run() {
            try {
                this.this$0.handler.stateUpdated(this.pinpointSocket, this.stateCode);
            }
            catch (Exception e) {
                this.this$0.logger.warn("Please handling exception in stateUpdated method. message:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

