/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.api.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookMQProducer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Producer hookMQProducer;

    public WebHookMQProducer(Properties properties, String connectorPluginType) {
        this.hookMQProducer = ConnectorPluginFactory.getMeshMQProducer((String)connectorPluginType);
        if (this.hookMQProducer == null) {
            this.logger.error("can't load the hookMQProducer plugin, please check.");
            throw new RuntimeException("doesn't load the hookMQProducer plugin, please check.");
        }
        try {
            this.hookMQProducer.init(properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void send(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        this.hookMQProducer.publish(cloudEvent, sendCallback);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.hookMQProducer.request(cloudEvent, rrCallback, timeout);
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        return this.hookMQProducer.reply(cloudEvent, sendCallback);
    }

    public Producer getHookMQProducer() {
        return this.hookMQProducer;
    }
}

