/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.etcd.service;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.registry.etcd.factory.EtcdClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRegistryService
implements RegistryService {
    private static final Logger logger = LoggerFactory.getLogger(EtcdRegistryService.class);
    private static final AtomicBoolean INIT_STATUS = new AtomicBoolean(false);
    private static final AtomicBoolean START_STATUS = new AtomicBoolean(false);
    private static final String KEY_PREFIX = "/eventMesh/registry/";
    private String serverAddr;
    private String username;
    private String password;
    private Client etcdClient;
    private Map<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;
    private ScheduledExecutorService etcdRegistryMonitorExecutorService;

    public void init() throws RegistryException {
        boolean update = INIT_STATUS.compareAndSet(false, true);
        if (!update) {
            return;
        }
        this.eventMeshRegisterInfoMap = new HashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.namesrvAddr)) {
                throw new RegistryException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.namesrvAddr;
            this.username = commonConfiguration.eventMeshRegistryPluginUsername;
            this.password = commonConfiguration.eventMeshRegistryPluginPassword;
            break;
        }
        this.etcdRegistryMonitorExecutorService = ThreadPoolFactory.createSingleScheduledExecutor((String)"EtcdRegistryMonitorThread");
    }

    public void start() throws RegistryException {
        boolean update = START_STATUS.compareAndSet(false, true);
        if (!update) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("serverAddr", this.serverAddr);
            properties.setProperty("username", this.username);
            properties.setProperty("password", this.password);
            this.etcdClient = EtcdClientFactory.createClient(properties);
            this.etcdRegistryMonitorExecutorService.scheduleAtFixedRate(new EventMeshEtcdRegisterMonitor(), 15000L, 15000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][start] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    public void shutdown() throws RegistryException {
        INIT_STATUS.compareAndSet(true, false);
        START_STATUS.compareAndSet(true, false);
        try {
            if (this.etcdClient != null) {
                this.etcdClient.close();
            }
            if (this.etcdRegistryMonitorExecutorService != null && !this.etcdRegistryMonitorExecutorService.isShutdown()) {
                this.etcdRegistryMonitorExecutorService.shutdown();
            }
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][shutdown] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        logger.info("EtcdRegistryService closed");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        try {
            Object keyPrefix = clusterName == null ? KEY_PREFIX : "/eventMesh/registry//" + clusterName;
            ByteSequence keyByteSequence = ByteSequence.from((byte[])((String)keyPrefix).getBytes(Constants.DEFAULT_CHARSET));
            GetOption getOption = GetOption.newBuilder().withPrefix(keyByteSequence).build();
            List keyValues = ((GetResponse)this.etcdClient.getKVClient().get(keyByteSequence, getOption).get()).getKvs();
            if (CollectionUtils.isNotEmpty((Collection)keyValues)) {
                for (KeyValue kv : keyValues) {
                    EventMeshDataInfo eventMeshDataInfo = (EventMeshDataInfo)JsonUtils.deserialize((String)new String(kv.getValue().getBytes(), Constants.DEFAULT_CHARSET), EventMeshDataInfo.class);
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][findEventMeshInfoByCluster] error, clusterName: {}", (Object)clusterName, (Object)e);
            throw new RegistryException(e.getMessage());
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        try {
            return this.findEventMeshInfoByCluster(null);
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws RegistryException {
        return null;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry<String, EventMeshRegisterInfo> eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
        String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
        String endPoint = eventMeshRegisterInfo.getEndPoint();
        try {
            ByteSequence etcdKey = this.getEtcdKey(eventMeshClusterName, eventMeshName, endPoint);
            EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(eventMeshClusterName, eventMeshName, endPoint, System.currentTimeMillis(), eventMeshRegisterInfo.getMetadata());
            ByteSequence etcdValue = ByteSequence.from((byte[])JsonUtils.serialize((Object)eventMeshDataInfo).getBytes(Constants.DEFAULT_CHARSET));
            this.etcdClient.getKVClient().put(etcdKey, etcdValue, PutOption.newBuilder().withLeaseId(this.getLeaseId()).build());
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
            logger.info("EventMesh successfully registered to etcd, eventMeshClusterName: {}, eventMeshName: {}", (Object)eventMeshClusterName, (Object)eventMeshName);
            return true;
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][register] error, eventMeshClusterName: {}, eventMeshName: {}", new Object[]{eventMeshClusterName, eventMeshName, e});
            throw new RegistryException(e.getMessage());
        }
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
        String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
        try {
            ByteSequence etcdKey = this.getEtcdKey(eventMeshClusterName, eventMeshName, eventMeshUnRegisterInfo.getEndPoint());
            this.etcdClient.getKVClient().delete(etcdKey);
            this.eventMeshRegisterInfoMap.remove(eventMeshName);
            logger.info("EventMesh successfully logout to etcd, eventMeshClusterName: {}, eventMeshName: {}", (Object)eventMeshClusterName, (Object)eventMeshName);
            return true;
        }
        catch (Exception e) {
            logger.error("[EtcdRegistryService][unRegister] error, eventMeshClusterName: {}, eventMeshName: {}", new Object[]{eventMeshClusterName, eventMeshName, e});
            throw new RegistryException(e.getMessage());
        }
    }

    public Client getEtcdClient() {
        return this.etcdClient;
    }

    public long getLeaseId() {
        return EtcdClientFactory.getLeaseId(this.serverAddr);
    }

    private ByteSequence getEtcdKey(String eventMeshClusterName, String eventMeshName, String endPoint) {
        StringBuilder etcdKey = new StringBuilder(KEY_PREFIX).append(eventMeshClusterName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eventMeshName})) {
            etcdKey.append("/").append(eventMeshName);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endPoint})) {
            etcdKey.append("/").append(endPoint);
        }
        return ByteSequence.from((byte[])etcdKey.toString().getBytes(Constants.DEFAULT_CHARSET));
    }

    private class EventMeshEtcdRegisterMonitor
    implements Runnable {
        private EventMeshEtcdRegisterMonitor() {
        }

        @Override
        public void run() {
            if (EtcdRegistryService.this.eventMeshRegisterInfoMap.size() > 0) {
                for (Map.Entry<String, EventMeshRegisterInfo> eventMeshRegisterInfoEntry : EtcdRegistryService.this.eventMeshRegisterInfoMap.entrySet()) {
                    EventMeshRegisterInfo eventMeshRegisterInfo = eventMeshRegisterInfoEntry.getValue();
                    ByteSequence etcdKey = EtcdRegistryService.this.getEtcdKey(eventMeshRegisterInfo.getEventMeshClusterName(), eventMeshRegisterInfo.getEventMeshName(), eventMeshRegisterInfo.getEndPoint());
                    List keyValues = null;
                    try {
                        keyValues = ((GetResponse)EtcdRegistryService.this.etcdClient.getKVClient().get(etcdKey).get()).getKvs();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error("get etcdKey[{}] failed", (Object)etcdKey, (Object)e);
                    }
                    if (!CollectionUtils.isEmpty(keyValues)) continue;
                    logger.warn("eventMeshRegisterInfo [{}] is not matched in Etcd , try to register again", (Object)eventMeshRegisterInfo.getEventMeshName());
                    EtcdClientFactory.renewalLeaseId(EtcdClientFactory.getEtcdLeaseId(EtcdRegistryService.this.serverAddr));
                    EtcdRegistryService.this.register(eventMeshRegisterInfo);
                }
            }
        }
    }
}

