/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.kafka.CloudEventDeserializer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.connector.kafka.consumer.KafkaConsumerRunner;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerImpl {
    public static final Logger logger = LoggerFactory.getLogger(ConsumerImpl.class);
    private final KafkaConsumer<String, CloudEvent> kafkaConsumer;
    private final Properties properties;
    private AtomicBoolean started = new AtomicBoolean(false);
    private EventListener eventListener;
    private KafkaConsumerRunner kafkaConsumerRunner;
    private ExecutorService executorService;
    private Set<String> topicsSet;

    public ConsumerImpl(Properties properties) {
        Properties props = new Properties();
        props.put("bootstrap.servers", properties.getProperty("bootstrap.servers"));
        props.put("value.deserializer", CloudEventDeserializer.class);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("group.id", properties.getProperty("group.id"));
        props.put("enable.auto.commit", "false");
        this.properties = props;
        this.kafkaConsumer = new KafkaConsumer(props);
        this.kafkaConsumerRunner = new KafkaConsumerRunner(this.kafkaConsumer);
        this.executorService = Executors.newFixedThreadPool(10);
        this.topicsSet = new HashSet<String>();
    }

    public Properties attributes() {
        return this.properties;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.executorService.submit(this.kafkaConsumerRunner);
        }
    }

    public synchronized void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.kafkaConsumer.close();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public KafkaConsumer<String, CloudEvent> getKafkaConsumer() {
        return this.kafkaConsumer;
    }

    public synchronized void subscribe(String topic) {
        try {
            this.topicsSet.add(topic);
            ArrayList<String> topics = new ArrayList<String>(this.topicsSet);
            this.kafkaConsumer.subscribe(topics);
        }
        catch (Exception e) {
            logger.error("Error while subscribing the Kafka consumer to topic: ", (Throwable)e);
            throw new ConnectorRuntimeException(String.format("Kafka consumer can't attach to %s.", topic));
        }
    }

    public synchronized void unsubscribe(String topic) {
        try {
            this.kafkaConsumer.unsubscribe();
            this.topicsSet.remove(topic);
            ArrayList<String> topics = new ArrayList<String>(this.topicsSet);
            this.kafkaConsumer.subscribe(topics);
        }
        catch (Exception e) {
            logger.error("Error while unsubscribing the Kafka consumer: ", (Throwable)e);
            throw new ConnectorRuntimeException(String.format("kafka push consumer fails to unsubscribe topic: %s", topic));
        }
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        Long maxOffset = cloudEvents.stream().map(cloudEvent -> this.kafkaConsumerRunner.getOffset((CloudEvent)cloudEvent)).max(Long::compare).get();
        cloudEvents.forEach(cloudEvent -> this.updateOffset(cloudEvent.getSubject(), maxOffset));
    }

    public void updateOffset(String topicName, long offset) {
        this.kafkaConsumer.seek(new TopicPartition(topicName, 1), offset);
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
        this.kafkaConsumerRunner.setListener(this.eventListener);
    }
}

