/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.openmessage;

import io.openmessaging.api.Message;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPPubClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPSubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.openmessage.OpenMessageTCPPubClient;
import org.apache.eventmesh.client.tcp.impl.openmessage.OpenMessageTCPSubClient;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMessageTCPClient
implements EventMeshTCPClient<Message> {
    private static final Logger log = LoggerFactory.getLogger(OpenMessageTCPClient.class);
    private final EventMeshTCPPubClient<Message> eventMeshTCPPubClient;
    private final EventMeshTCPSubClient<Message> eventMeshTCPSubClient;

    public OpenMessageTCPClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        this.eventMeshTCPPubClient = new OpenMessageTCPPubClient(eventMeshTcpClientConfig);
        this.eventMeshTCPSubClient = new OpenMessageTCPSubClient(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        this.eventMeshTCPPubClient.init();
        this.eventMeshTCPSubClient.init();
    }

    @Override
    public Package rr(Message openMessage, long timeout) throws EventMeshException {
        return this.eventMeshTCPPubClient.rr(openMessage, timeout);
    }

    @Override
    public void asyncRR(Message openMessage, AsyncRRCallback callback, long timeout) throws EventMeshException {
        this.eventMeshTCPPubClient.asyncRR(openMessage, callback, timeout);
    }

    @Override
    public Package publish(Message openMessage, long timeout) throws EventMeshException {
        return this.eventMeshTCPPubClient.publish(openMessage, timeout);
    }

    @Override
    public void broadcast(Message openMessage, long timeout) throws EventMeshException {
        this.eventMeshTCPPubClient.broadcast(openMessage, timeout);
    }

    @Override
    public void listen() throws EventMeshException {
        this.eventMeshTCPSubClient.listen();
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) throws EventMeshException {
        this.eventMeshTCPSubClient.subscribe(topic, subscriptionMode, subscriptionType);
    }

    @Override
    public void unsubscribe() throws EventMeshException {
        this.eventMeshTCPSubClient.unsubscribe();
    }

    @Override
    public void registerPubBusiHandler(ReceiveMsgHook<Message> handler) throws EventMeshException {
        this.eventMeshTCPPubClient.registerBusiHandler(handler);
    }

    @Override
    public void registerSubBusiHandler(ReceiveMsgHook<Message> handler) throws EventMeshException {
        this.eventMeshTCPSubClient.registerBusiHandler(handler);
    }

    @Override
    public void close() throws EventMeshException {
        try (EventMeshTCPPubClient<Message> pubClient = this.eventMeshTCPPubClient;
             EventMeshTCPSubClient<Message> subClient = this.eventMeshTCPSubClient;){
            log.info("Close OpenMessageTCPClient");
        }
    }

    @Override
    public EventMeshTCPPubClient<Message> getPubClient() {
        return this.eventMeshTCPPubClient;
    }

    @Override
    public EventMeshTCPSubClient<Message> getSubClient() {
        return this.eventMeshTCPSubClient;
    }
}

