/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.cloudevent;

import io.cloudevents.CloudEvent;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPPubClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPSubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.cloudevent.CloudEventTCPPubClient;
import org.apache.eventmesh.client.tcp.impl.cloudevent.CloudEventTCPSubClient;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Package;

public class CloudEventTCPClient
implements EventMeshTCPClient<CloudEvent> {
    private final CloudEventTCPPubClient cloudEventTCPPubClient;
    private final CloudEventTCPSubClient cloudEventTCPSubClient;

    public CloudEventTCPClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        this.cloudEventTCPPubClient = new CloudEventTCPPubClient(eventMeshTcpClientConfig);
        this.cloudEventTCPSubClient = new CloudEventTCPSubClient(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        this.cloudEventTCPPubClient.init();
        this.cloudEventTCPSubClient.init();
    }

    @Override
    public Package rr(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        return this.cloudEventTCPPubClient.rr(cloudEvent, timeout);
    }

    @Override
    public void asyncRR(CloudEvent cloudEvent, AsyncRRCallback callback, long timeout) throws EventMeshException {
        this.cloudEventTCPPubClient.asyncRR(cloudEvent, callback, timeout);
    }

    @Override
    public Package publish(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        return this.cloudEventTCPPubClient.publish(cloudEvent, timeout);
    }

    @Override
    public void broadcast(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        this.cloudEventTCPPubClient.broadcast(cloudEvent, timeout);
    }

    @Override
    public void listen() throws EventMeshException {
        this.cloudEventTCPSubClient.listen();
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) throws EventMeshException {
        this.cloudEventTCPSubClient.subscribe(topic, subscriptionMode, subscriptionType);
    }

    @Override
    public void unsubscribe() throws EventMeshException {
        this.cloudEventTCPSubClient.unsubscribe();
    }

    @Override
    public void registerPubBusiHandler(ReceiveMsgHook<CloudEvent> handler) throws EventMeshException {
        this.cloudEventTCPPubClient.registerBusiHandler(handler);
    }

    @Override
    public void registerSubBusiHandler(ReceiveMsgHook<CloudEvent> handler) throws EventMeshException {
        this.cloudEventTCPSubClient.registerBusiHandler(handler);
    }

    @Override
    public void close() throws EventMeshException {
        try (CloudEventTCPPubClient pubClient = this.cloudEventTCPPubClient;){
            CloudEventTCPSubClient subClient = this.cloudEventTCPSubClient;
            if (subClient != null) {
                subClient.close();
            }
        }
    }

    @Override
    public EventMeshTCPPubClient<CloudEvent> getPubClient() {
        return this.cloudEventTCPPubClient;
    }

    @Override
    public EventMeshTCPSubClient<CloudEvent> getSubClient() {
        return this.cloudEventTCPSubClient;
    }
}

