/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.util;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.common.Constants;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String post(CloseableHttpClient client, String uri, RequestParam requestParam) throws Exception {
        ResponseHolder responseHolder = new ResponseHolder();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtils.post(client, null, uri, requestParam, (ResponseHandler<String>)((ResponseHandler)response -> {
            responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET);
            countDownLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)responseHolder);
            }
            return responseHolder.response;
        }));
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static String post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam) throws Exception {
        ResponseHolder responseHolder = new ResponseHolder();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtils.post(client, forwardAgent, uri, requestParam, (ResponseHandler<String>)((ResponseHandler)response -> {
            responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET);
            countDownLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)responseHolder);
            }
            return responseHolder.response;
        }));
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static void post(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws IOException {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((responseHandler != null ? 1 : 0) != 0, (Object)"responseHandler can't be null");
        Preconditions.checkState((requestParam.getHttpMethod() == HttpMethod.POST ? 1 : 0) != 0, (Object)"invalid requestParam httpMethod");
        HttpPost httpPost = new HttpPost(uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(requestParam.getBody())) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : requestParam.getBody().entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Constants.DEFAULT_CHARSET));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpPost.setConfig(configBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)httpPost);
        }
        client.execute((HttpUriRequest)httpPost, responseHandler);
    }

    public static void get(CloseableHttpClient client, HttpHost forwardAgent, String uri, RequestParam requestParam, ResponseHandler<String> responseHandler) throws Exception {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestParam != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((requestParam.getHttpMethod() == HttpMethod.GET ? 1 : 0) != 0, (Object)"invalid requestParam httpMethod");
        if (MapUtils.isNotEmpty(requestParam.getQueryParamsMap())) {
            uri = (String)uri + "?" + requestParam.getQueryParams();
        }
        HttpGet httpGet = new HttpGet((String)uri);
        if (MapUtils.isNotEmpty(requestParam.getHeaders())) {
            for (Map.Entry<String, String> entry : requestParam.getHeaders().entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout()))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(requestParam.getTimeout())));
        if (forwardAgent != null) {
            configBuilder.setProxy(forwardAgent);
        }
        httpGet.setConfig(configBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)httpGet);
        }
        client.execute((HttpUriRequest)httpGet, responseHandler);
    }

    public static String get(CloseableHttpClient client, String url, RequestParam requestParam) throws Exception {
        ResponseHolder responseHolder = new ResponseHolder();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtils.get(client, null, url, requestParam, (ResponseHandler<String>)((ResponseHandler)response -> {
            responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET);
            countDownLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)responseHolder);
            }
            return responseHolder.response;
        }));
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static String get(CloseableHttpClient client, HttpHost forwardAgent, String url, RequestParam requestParam) throws Exception {
        ResponseHolder responseHolder = new ResponseHolder();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        HttpUtils.get(client, forwardAgent, url, requestParam, (ResponseHandler<String>)((ResponseHandler)response -> {
            responseHolder.response = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET);
            countDownLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)responseHolder);
            }
            return responseHolder.response;
        }));
        try {
            countDownLatch.await(requestParam.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return responseHolder.response;
    }

    public static class ResponseHolder {
        public String response;

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseHolder)) {
                return false;
            }
            ResponseHolder other = (ResponseHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$response = this.getResponse();
            String other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !this$response.equals(other$response));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            return result;
        }

        public String toString() {
            return "HttpUtils.ResponseHolder(response=" + this.getResponse() + ")";
        }
    }
}

