/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import io.openmessaging.api.Message;
import java.io.IOException;
import org.apache.eventmesh.client.http.AbstractHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.client.http.producer.EventMeshProtocolProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.client.http.producer.RRCallbackResponseHandlerAdapter;
import org.apache.eventmesh.client.http.util.HttpUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenMessageProducer
extends AbstractHttpClient
implements EventMeshProtocolProducer<Message> {
    private static final Logger log = LoggerFactory.getLogger(OpenMessageProducer.class);

    public OpenMessageProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public void publish(Message openMessage) throws EventMeshException {
        this.validateOpenMessage(openMessage);
        RequestParam requestParam = this.buildCommonPostParam(openMessage).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
        }
        catch (Exception exception) {
            throw new EventMeshException(String.format("Publish message error, target:%s", target), (Throwable)exception);
        }
    }

    @Override
    public Message request(Message message, long timeout) throws EventMeshException {
        this.validateOpenMessage(message);
        RequestParam requestParam = this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                return this.transformMessage(ret);
            }
            throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
        }
        catch (Exception e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    @Override
    public void request(Message message, RRCallback<Message> rrCallback, long timeout) throws EventMeshException {
        this.validateOpenMessage(message);
        RequestParam requestParam = this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        RRCallbackResponseHandlerAdapter<Message> adapter = new RRCallbackResponseHandlerAdapter<Message>(message, rrCallback, timeout);
        try {
            HttpUtils.post(this.httpClient, null, target, requestParam, adapter);
        }
        catch (IOException e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    private void validateOpenMessage(Message openMessage) {
        Preconditions.checkNotNull((Object)openMessage, (Object)"Message cannot be null");
    }

    private RequestParam buildCommonPostParam(Message openMessage) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("language", "JAVA").addHeader("protocoltype", "openmessage").addHeader("protocoldesc", "http").addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("content", JsonUtils.serialize((Object)openMessage));
        return requestParam;
    }

    private Message transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return null;
    }
}

