/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.consumer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.ReceiveMsgHook;
import org.apache.eventmesh.client.grpc.consumer.SubStreamHandler;
import org.apache.eventmesh.client.grpc.util.EventMeshClientUtil;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.Heartbeat;
import org.apache.eventmesh.common.protocol.grpc.protos.HeartbeatServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcConsumer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EventMeshGrpcConsumer.class);
    private static final String SDK_STREAM_URL = "grpc_stream";
    private final EventMeshGrpcClientConfig clientConfig;
    private final Map<String, SubscriptionInfo> subscriptionMap = new ConcurrentHashMap<String, SubscriptionInfo>();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("GRPCClientScheduler").setDaemon(true).build());
    private ManagedChannel channel;
    ConsumerServiceGrpc.ConsumerServiceBlockingStub consumerClient;
    ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient;
    HeartbeatServiceGrpc.HeartbeatServiceBlockingStub heartbeatClient;
    private ReceiveMsgHook<?> listener;
    private SubStreamHandler<?> subStreamHandler;

    public EventMeshGrpcConsumer(EventMeshGrpcClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.clientConfig.getServerAddr(), (int)this.clientConfig.getServerPort()).usePlaintext().build();
        this.consumerClient = ConsumerServiceGrpc.newBlockingStub((Channel)this.channel);
        this.consumerAsyncClient = ConsumerServiceGrpc.newStub((Channel)this.channel);
        this.heartbeatClient = HeartbeatServiceGrpc.newBlockingStub((Channel)this.channel);
        this.heartBeat();
    }

    public Response subscribe(List<SubscriptionItem> subscriptionItems, String url) {
        logger.info("Create subscription: " + subscriptionItems + ", url: " + url);
        this.addSubscription(subscriptionItems, url);
        Subscription subscription = this.buildSubscription(subscriptionItems, url);
        try {
            Response response = this.consumerClient.subscribe(subscription);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in subscribe. error {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(List<SubscriptionItem> subscriptionItems) {
        logger.info("Create streaming subscription: " + subscriptionItems);
        if (this.listener == null) {
            logger.error("Error in subscriber, no Event Listener is registered.");
            return;
        }
        this.addSubscription(subscriptionItems, SDK_STREAM_URL);
        Subscription subscription = this.buildSubscription(subscriptionItems, null);
        EventMeshGrpcConsumer eventMeshGrpcConsumer = this;
        synchronized (eventMeshGrpcConsumer) {
            if (this.subStreamHandler == null) {
                this.subStreamHandler = new SubStreamHandler(this.consumerAsyncClient, this.clientConfig, this.listener);
                this.subStreamHandler.start();
            }
        }
        this.subStreamHandler.sendSubscription(subscription);
    }

    private void addSubscription(List<SubscriptionItem> subscriptionItems, String url) {
        for (SubscriptionItem item : subscriptionItems) {
            this.subscriptionMap.put(item.getTopic(), new SubscriptionInfo(item, url));
        }
    }

    private void removeSubscription(List<SubscriptionItem> subscriptionItems) {
        for (SubscriptionItem item : subscriptionItems) {
            this.subscriptionMap.remove(item.getTopic());
        }
    }

    public Response unsubscribe(List<SubscriptionItem> subscriptionItems, String url) {
        logger.info("Removing subscription: " + subscriptionItems + ", url: " + url);
        this.removeSubscription(subscriptionItems);
        Subscription subscription = this.buildSubscription(subscriptionItems, url);
        try {
            Response response = this.consumerClient.unsubscribe(subscription);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in unsubscribe. error {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response unsubscribe(List<SubscriptionItem> subscriptionItems) {
        logger.info("Removing subscription stream: " + subscriptionItems);
        this.removeSubscription(subscriptionItems);
        Subscription subscription = this.buildSubscription(subscriptionItems, null);
        try {
            Response response = this.consumerClient.unsubscribe(subscription);
            logger.info("Received response " + response.toString());
            EventMeshGrpcConsumer eventMeshGrpcConsumer = this;
            synchronized (eventMeshGrpcConsumer) {
                if (this.subscriptionMap.isEmpty() && this.subStreamHandler != null) {
                    this.subStreamHandler.close();
                    this.subStreamHandler = null;
                }
            }
            return response;
        }
        catch (Exception e) {
            logger.error("Error in unsubscribe. error {}", (Object)e.getMessage());
            return null;
        }
    }

    private Subscription buildSubscription(List<SubscriptionItem> subscriptionItems, String url) {
        Subscription.Builder builder = Subscription.newBuilder().setHeader(EventMeshClientUtil.buildHeader(this.clientConfig, "eventmeshmessage")).setConsumerGroup(this.clientConfig.getConsumerGroup());
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            builder.setUrl(url);
        }
        for (SubscriptionItem subscriptionItem : subscriptionItems) {
            Subscription.SubscriptionItem.SubscriptionMode mode = SubscriptionMode.CLUSTERING.equals((Object)subscriptionItem.getMode()) ? Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING : (SubscriptionMode.BROADCASTING.equals((Object)subscriptionItem.getMode()) ? Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING : Subscription.SubscriptionItem.SubscriptionMode.UNRECOGNIZED);
            Subscription.SubscriptionItem.SubscriptionType type = SubscriptionType.ASYNC.equals((Object)subscriptionItem.getType()) ? Subscription.SubscriptionItem.SubscriptionType.ASYNC : (SubscriptionType.SYNC.equals((Object)subscriptionItem.getType()) ? Subscription.SubscriptionItem.SubscriptionType.SYNC : Subscription.SubscriptionItem.SubscriptionType.UNRECOGNIZED);
            Subscription.SubscriptionItem item = Subscription.SubscriptionItem.newBuilder().setTopic(subscriptionItem.getTopic()).setMode(mode).setType(type).build();
            builder.addSubscriptionItems(item);
        }
        return builder.build();
    }

    public synchronized void registerListener(ReceiveMsgHook<?> listener) {
        if (this.listener == null) {
            this.listener = listener;
        }
    }

    private void heartBeat() {
        RequestHeader header = EventMeshClientUtil.buildHeader(this.clientConfig, "eventmeshmessage");
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.subscriptionMap.isEmpty()) {
                return;
            }
            Heartbeat.Builder heartbeatBuilder = Heartbeat.newBuilder().setHeader(header).setConsumerGroup(this.clientConfig.getConsumerGroup()).setClientType(Heartbeat.ClientType.SUB);
            for (Map.Entry<String, SubscriptionInfo> entry : this.subscriptionMap.entrySet()) {
                Heartbeat.HeartbeatItem heartbeatItem = Heartbeat.HeartbeatItem.newBuilder().setTopic(entry.getKey()).setUrl(entry.getValue().getUrl()).build();
                heartbeatBuilder.addHeartbeatItems(heartbeatItem);
            }
            Heartbeat heartbeat = heartbeatBuilder.build();
            try {
                Response response = this.heartbeatClient.heartbeat(heartbeat);
                if (logger.isDebugEnabled()) {
                    logger.debug("Grpc Consumer Heartbeat response: {}", (Object)response);
                }
                if (StatusCode.CLIENT_RESUBSCRIBE.getRetCode().equals(response.getRespCode())) {
                    this.resubscribe();
                }
            }
            catch (Exception e) {
                logger.error("Error in sending out heartbeat. error {}", (Object)e.getMessage());
            }
        }, 10000L, 30000L, TimeUnit.MILLISECONDS);
        logger.info("Grpc Consumer Heartbeat started.");
    }

    private void resubscribe() {
        if (this.subscriptionMap.isEmpty()) {
            return;
        }
        Map subscriptionGroup = this.subscriptionMap.values().stream().collect(Collectors.groupingBy(SubscriptionInfo::getUrl, Collectors.mapping(SubscriptionInfo::getSubscriptionItem, Collectors.toList())));
        subscriptionGroup.forEach((url, items) -> {
            Subscription subscription = this.buildSubscription((List<SubscriptionItem>)items, (String)url);
            this.subStreamHandler.sendSubscription(subscription);
        });
    }

    @Override
    public void close() {
        if (this.subStreamHandler != null) {
            this.subStreamHandler.close();
        }
        this.channel.shutdown();
        this.scheduler.shutdown();
    }

    private static class SubscriptionInfo {
        private SubscriptionItem subscriptionItem;
        private String url;

        SubscriptionInfo(SubscriptionItem subscriptionItem, String url) {
            this.subscriptionItem = subscriptionItem;
            this.url = url;
        }

        public SubscriptionItem getSubscriptionItem() {
            return this.subscriptionItem;
        }

        public void setSubscriptionItem(SubscriptionItem subscriptionItem) {
            this.subscriptionItem = subscriptionItem;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

