/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.catalog;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.catalog.config.EventMeshCatalogClientConfig;
import org.apache.eventmesh.client.grpc.consumer.EventMeshGrpcConsumer;
import org.apache.eventmesh.client.selector.Selector;
import org.apache.eventmesh.client.selector.SelectorFactory;
import org.apache.eventmesh.client.selector.ServiceInstance;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.catalog.protos.CatalogGrpc;
import org.apache.eventmesh.common.protocol.catalog.protos.Operation;
import org.apache.eventmesh.common.protocol.catalog.protos.QueryOperationsRequest;
import org.apache.eventmesh.common.protocol.catalog.protos.QueryOperationsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshCatalogClient {
    private static final Logger logger = LoggerFactory.getLogger(EventMeshCatalogClient.class);
    private final EventMeshCatalogClientConfig clientConfig;
    private final EventMeshGrpcConsumer eventMeshGrpcConsumer;
    private final List<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();

    public EventMeshCatalogClient(EventMeshCatalogClientConfig clientConfig, EventMeshGrpcConsumer eventMeshGrpcConsumer) {
        this.clientConfig = clientConfig;
        this.eventMeshGrpcConsumer = eventMeshGrpcConsumer;
    }

    public void init() throws Exception {
        List operations;
        Selector selector = SelectorFactory.get(this.clientConfig.getSelectorType());
        if (selector == null) {
            throw new Exception(String.format("selector=%s not register.please check it.", this.clientConfig.getSelectorType()));
        }
        ServiceInstance instance = selector.selectOne(this.clientConfig.getServerName());
        if (instance == null) {
            throw new Exception("catalog server is not running.please check it.");
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)instance.getHost(), (int)instance.getPort()).usePlaintext().build();
        CatalogGrpc.CatalogBlockingStub catalogClient = CatalogGrpc.newBlockingStub((Channel)channel);
        QueryOperationsRequest request = QueryOperationsRequest.newBuilder().setServiceName(this.clientConfig.getAppServerName()).build();
        try {
            QueryOperationsResponse response = catalogClient.queryOperations(request);
            logger.info("received response: {}", (Object)response.toString());
            operations = response.getOperationsList();
            if (CollectionUtils.isEmpty((Collection)operations)) {
                return;
            }
        }
        catch (Exception e) {
            logger.error("queryOperations error {}", (Object)e.getMessage());
            throw e;
        }
        for (Operation operation : operations) {
            if (!operation.getType().equals("subscribe")) continue;
            SubscriptionItem subscriptionItem = new SubscriptionItem();
            subscriptionItem.setTopic(operation.getChannelName());
            subscriptionItem.setMode(this.clientConfig.getSubscriptionMode());
            subscriptionItem.setType(this.clientConfig.getSubscriptionType());
            this.subscriptionItems.add(subscriptionItem);
        }
        this.eventMeshGrpcConsumer.subscribe(this.subscriptionItems);
    }

    public void destroy() {
        if (this.subscriptionItems.isEmpty()) {
            return;
        }
        this.eventMeshGrpcConsumer.unsubscribe(this.subscriptionItems);
    }
}

