/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.apache.eventmesh.webhook.api.WebHookOperationConstant;
import org.apache.eventmesh.webhook.api.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWebHookConfigOperation
implements WebHookConfigOperation {
    private static final Logger logger = LoggerFactory.getLogger(FileWebHookConfigOperation.class);
    private final String webHookFilePath;

    public FileWebHookConfigOperation(Properties properties) throws FileNotFoundException {
        String webHookFilePath = WebHookOperationConstant.getFilePath((String)properties.getProperty("filePath"));
        File webHookFileDir = new File(webHookFilePath);
        if (!webHookFileDir.exists()) {
            webHookFileDir.mkdirs();
        }
        if (!webHookFileDir.isDirectory()) {
            throw new FileNotFoundException("File path " + webHookFilePath + " is not directory");
        }
        this.webHookFilePath = webHookFilePath;
    }

    public Integer insertWebHookConfig(WebHookConfig webHookConfig) {
        File webhookConfigFile;
        if (!webHookConfig.getCallbackPath().startsWith("/webhook")) {
            logger.error("webhookConfig callback path must start with {}", (Object)"/webhook");
            return 0;
        }
        File manuDir = new File(this.getWebhookConfigManuDir(webHookConfig));
        if (!manuDir.exists()) {
            manuDir.mkdir();
        }
        if ((webhookConfigFile = this.getWebhookConfigFile(webHookConfig)).exists()) {
            logger.error("webhookConfig {} is existed", (Object)webHookConfig.getCallbackPath());
            return 0;
        }
        return this.writeToFile(webhookConfigFile, webHookConfig) ? 1 : 0;
    }

    public Integer updateWebHookConfig(WebHookConfig webHookConfig) {
        File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
        if (!webhookConfigFile.exists()) {
            logger.error("webhookConfig {} is not existed", (Object)webHookConfig.getCallbackPath());
            return 0;
        }
        return this.writeToFile(webhookConfigFile, webHookConfig) ? 1 : 0;
    }

    public Integer deleteWebHookConfig(WebHookConfig webHookConfig) {
        File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
        if (!webhookConfigFile.exists()) {
            logger.error("webhookConfig {} is not existed", (Object)webHookConfig.getCallbackPath());
            return 0;
        }
        return webhookConfigFile.delete() ? 1 : 0;
    }

    public WebHookConfig queryWebHookConfigById(WebHookConfig webHookConfig) {
        File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
        if (!webhookConfigFile.exists()) {
            logger.error("webhookConfig {} is not existed", (Object)webHookConfig.getCallbackPath());
            return null;
        }
        return this.getWebHookConfigFromFile(webhookConfigFile);
    }

    public List<WebHookConfig> queryWebHookConfigByManufacturer(WebHookConfig webHookConfig, Integer pageNum, Integer pageSize) {
        String manuDirPath = this.getWebhookConfigManuDir(webHookConfig);
        File manuDir = new File(manuDirPath);
        if (!manuDir.exists()) {
            logger.warn("webhookConfig dir {} is not existed", (Object)manuDirPath);
            return new ArrayList<WebHookConfig>();
        }
        ArrayList<WebHookConfig> webHookConfigs = new ArrayList<WebHookConfig>();
        File[] webhookFiles = manuDir.listFiles();
        if (webhookFiles == null || webhookFiles.length == 0) {
            return webHookConfigs;
        }
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = pageNum * pageSize - 1;
        if (webhookFiles.length > startIndex) {
            for (int i = startIndex; i <= endIndex && i < webhookFiles.length; ++i) {
                webHookConfigs.add(this.getWebHookConfigFromFile(webhookFiles[i]));
            }
        }
        return webHookConfigs;
    }

    private WebHookConfig getWebHookConfigFromFile(File webhookConfigFile) {
        StringBuffer fileContent = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(webhookConfigFile)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                fileContent.append(line);
            }
        }
        catch (IOException e) {
            logger.error("get webhook from file {} error", (Object)webhookConfigFile.getPath(), (Object)e);
            return null;
        }
        return (WebHookConfig)JsonUtils.deserialize((String)fileContent.toString(), WebHookConfig.class);
    }

    public boolean writeToFile(File webhookConfigFile, WebHookConfig webHookConfig) {
        try (FileOutputStream fos = new FileOutputStream(webhookConfigFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));){
            fos.getChannel().lock();
            bw.write(JsonUtils.serialize((Object)webHookConfig));
        }
        catch (IOException e) {
            logger.error("write webhookConfig {} to file error", (Object)webHookConfig.getCallbackPath());
            return false;
        }
        return true;
    }

    private String getWebhookConfigManuDir(WebHookConfig webHookConfig) {
        return this.webHookFilePath + WebHookOperationConstant.FILE_SEPARATOR + webHookConfig.getManufacturerName();
    }

    private File getWebhookConfigFile(WebHookConfig webHookConfig) {
        String webhookConfigFilePath = this.getWebhookConfigManuDir(webHookConfig) + WebHookOperationConstant.FILE_SEPARATOR + StringUtils.getFileName((String)webHookConfig.getCallbackPath());
        return new File(webhookConfigFilePath);
    }
}

