/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.connector.redis.client.RedissonClient;
import org.redisson.Redisson;
import org.redisson.api.RTopic;

public class RedisProducer
implements Producer {
    private Redisson redisson;
    private volatile boolean started = false;

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public synchronized void shutdown() {
        if (this.started) {
            try {
                this.redisson = null;
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties properties) {
        this.redisson = RedissonClient.INSTANCE;
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) {
        Preconditions.checkNotNull((Object)cloudEvent);
        Preconditions.checkNotNull((Object)sendCallback);
        try {
            RTopic topic = this.redisson.getTopic(cloudEvent.getSubject());
            topic.publishAsync((Object)cloudEvent).whenCompleteAsync((stage, throwable) -> {
                if (throwable != null) {
                    sendCallback.onException(OnExceptionContext.builder().topic(cloudEvent.getSubject()).messageId(cloudEvent.getId()).exception(new ConnectorRuntimeException(throwable)).build());
                } else {
                    SendResult sendResult = new SendResult();
                    sendResult.setTopic(cloudEvent.getSubject());
                    sendResult.setMessageId(cloudEvent.getId());
                    sendCallback.onSuccess(sendResult);
                }
            });
        }
        catch (Exception e) {
            sendCallback.onException(OnExceptionContext.builder().topic(cloudEvent.getSubject()).messageId(cloudEvent.getId()).exception(new ConnectorRuntimeException((Throwable)e)).build());
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent);
        RTopic topic = this.redisson.getTopic(cloudEvent.getSubject());
        topic.publish((Object)cloudEvent);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) {
        throw new ConnectorRuntimeException("Request is not supported");
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) {
        throw new ConnectorRuntimeException("Reply is not supported");
    }

    public void checkTopicExist(String topic) {
    }

    public void setExtFields() {
    }
}

