/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.connector.redis.cloudevent.CloudEventCodec;
import org.apache.eventmesh.connector.redis.config.ConfigurationWrapper;
import org.apache.eventmesh.connector.redis.config.RedisProperties;
import org.redisson.Redisson;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;

public final class RedissonClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Redisson INSTANCE;

    public static Redisson create() {
        String serverPassword;
        RedisProperties properties = new RedisProperties();
        String serverTypeName = ConfigurationWrapper.getProperty("eventMesh.server.redis.serverType");
        if (serverTypeName != null) {
            try {
                properties.setServerType(RedisProperties.ServerType.valueOf(serverTypeName));
            }
            catch (Exception e) {
                String message = "Invalid Redis server type: " + properties.getServerType() + ", supported values are: " + Arrays.toString((Object[])RedisProperties.ServerType.values());
                throw new ConnectorRuntimeException(message, (Throwable)e);
            }
        } else {
            properties.setServerType(RedisProperties.ServerType.SINGLE);
        }
        String serverAddress = ConfigurationWrapper.getProperty("eventMesh.server.redis.serverAddress");
        if (serverAddress == null) {
            throw new ConnectorRuntimeException("Lack Redis server address");
        }
        properties.setServerAddress(serverAddress);
        String serverMasterName = ConfigurationWrapper.getProperty("eventMesh.server.redis.serverMasterName");
        if (serverMasterName != null) {
            properties.setServerMasterName(serverMasterName);
        }
        if ((serverPassword = ConfigurationWrapper.getProperty("eventMesh.server.redis.serverPassword")) != null) {
            properties.setServerPassword(serverPassword);
        }
        properties.setRedissonProperties(ConfigurationWrapper.getPropertiesByPrefix("eventMesh.server.redis.redisson"));
        return RedissonClient.create(properties);
    }

    private static Redisson create(RedisProperties properties) {
        RedisProperties.ServerType serverType;
        try {
            serverType = properties.getServerType();
        }
        catch (IllegalArgumentException ie) {
            String message = "Invalid Redis server type: " + properties.getServerType() + ", supported values are: " + Arrays.toString((Object[])RedisProperties.ServerType.values());
            throw new ConnectorRuntimeException(message, (Throwable)ie);
        }
        String serverAddress = properties.getServerAddress();
        String serverPassword = properties.getServerPassword();
        String masterName = properties.getServerMasterName();
        Config config = (Config)OBJECT_MAPPER.convertValue((Object)properties.getRedissonProperties(), Config.class);
        if (config == null) {
            config = new Config();
        }
        config.setCodec((Codec)CloudEventCodec.INSTANCE);
        switch (serverType) {
            case SINGLE: {
                config.useSingleServer().setAddress(serverAddress).setPassword(serverPassword);
                break;
            }
            case CLUSTER: {
                config.useClusterServers().addNodeAddress(serverAddress.split(",")).setPassword(serverPassword);
                break;
            }
            case SENTINEL: {
                config.useSentinelServers().setMasterName(masterName).addSentinelAddress(new String[]{serverAddress}).setPassword(serverPassword);
                break;
            }
            default: {
                String message = "Invalid Redis server type: " + properties.getServerType() + ", supported values are: " + Arrays.toString((Object[])RedisProperties.ServerType.values());
                throw new ConnectorRuntimeException(message);
            }
        }
        return (Redisson)Redisson.create((Config)config);
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        INSTANCE = RedissonClient.create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                INSTANCE.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

