/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.pinpoint;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.config.ExporterConfiguration;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.pinpoint.config.PinpointConfiguration;
import org.apache.eventmesh.trace.pinpoint.exporter.PinpointSpanExporter;

public class PinpointTraceService
implements EventMeshTraceService {
    private SdkTracerProvider sdkTracerProvider;
    private Tracer tracer;
    private TextMapPropagator textMapPropagator;
    protected Thread shutdownHook;

    public void init() throws TraceException {
        long eventMeshTraceExportInterval = ExporterConfiguration.getEventMeshTraceExportInterval();
        long eventMeshTraceExportTimeout = ExporterConfiguration.getEventMeshTraceExportTimeout();
        int eventMeshTraceMaxExportSize = ExporterConfiguration.getEventMeshTraceMaxExportSize();
        int eventMeshTraceMaxQueueSize = ExporterConfiguration.getEventMeshTraceMaxQueueSize();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)new PinpointSpanExporter(PinpointConfiguration.getAgentId(), PinpointConfiguration.getAgentName(), PinpointConfiguration.getApplicationName(), PinpointConfiguration.getGrpcTransportConfig())).setScheduleDelay(eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout(eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(eventMeshTraceMaxExportSize).setMaxQueueSize(eventMeshTraceMaxQueueSize).build();
        this.sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)spanProcessor).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(this.sdkTracerProvider).build();
        this.tracer = openTelemetry.getTracer("eventmesh_trace");
        this.textMapPropagator = openTelemetry.getPropagators().getTextMapPropagator();
        this.shutdownHook = new Thread(() -> ((SdkTracerProvider)this.sdkTracerProvider).close());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Context extractFrom(Context context, Map<String, Object> carrier) throws TraceException {
        this.textMapPropagator.extract(context, carrier, (TextMapGetter)new TextMapGetter<Map<String, Object>>(){

            public Iterable<String> keys(@Nonnull Map<String, Object> carrier) {
                return carrier.keySet();
            }

            public String get(Map<String, Object> carrier, @Nonnull String key) {
                return Optional.ofNullable(carrier.get(key)).map(Objects::toString).orElse(null);
            }
        });
        return context;
    }

    public void inject(Context context, Map<String, Object> carrier) {
        this.textMapPropagator.inject(context, carrier, (cr, key, value) -> {
            if (cr != null) {
                cr.put(key, value);
            }
        });
    }

    public Span createSpan(String spanName, SpanKind spanKind, long startTimestamp, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(startTimestamp, timeUnit).startSpan();
    }

    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS).startSpan();
    }

    public void shutdown() throws TraceException {
        this.sdkTracerProvider.close();
    }
}

