/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import java.util.function.Supplier;
import org.apache.eventmesh.metrics.api.model.GrpcSummaryMetrics;

public final class PrometheusGrpcExporter {
    private static final String UNIT = "GRPC";
    private static final String METRICS_NAME_PREFIX = "eventmesh.grpc.";

    private static void observeOfValue(Meter meter, String name, String desc, Supplier<Long> supplier) {
        meter.doubleValueObserverBuilder(METRICS_NAME_PREFIX + name).setDescription(desc).setUnit(UNIT).setUpdater(result -> result.observe((double)((Long)supplier.get()).longValue(), Labels.empty())).build();
    }

    public static void export(String meterName, GrpcSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)meterName);
        PrometheusGrpcExporter.observeOfValue(meter, "sub.topic.num", "get sub topic num.", () -> ((GrpcSummaryMetrics)summaryMetrics).getSubscribeTopicNum());
        PrometheusGrpcExporter.observeOfValue(meter, "retry.queue.size", "get size of retry queue.", () -> ((GrpcSummaryMetrics)summaryMetrics).getRetrySize());
        PrometheusGrpcExporter.observeOfValue(meter, "server.tps", "get size of retry queue.", () -> ((GrpcSummaryMetrics)summaryMetrics).getClient2EventMeshTPS());
        PrometheusGrpcExporter.observeOfValue(meter, "client.tps", "get tps of eventMesh to mq.", () -> ((GrpcSummaryMetrics)summaryMetrics).getEventMesh2ClientTPS());
        PrometheusGrpcExporter.observeOfValue(meter, "mq.provider.tps", "get tps of eventMesh to mq.", () -> ((GrpcSummaryMetrics)summaryMetrics).getEventMesh2MqTPS());
        PrometheusGrpcExporter.observeOfValue(meter, "mq.consumer.tps", "get tps of eventMesh to mq.", () -> ((GrpcSummaryMetrics)summaryMetrics).getMq2EventMeshTPS());
    }

    private PrometheusGrpcExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

