/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import io.cloudevents.CloudEvent;
import java.util.Optional;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqClient;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqConnectionFactory;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEvent;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEventWriter;
import org.apache.eventmesh.connector.rabbitmq.config.ConfigurationHolder;
import org.apache.eventmesh.connector.rabbitmq.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqProducer.class);
    private RabbitmqConnectionFactory rabbitmqConnectionFactory = new RabbitmqConnectionFactory();
    private RabbitmqClient rabbitmqClient;
    private Connection connection;
    private Channel channel;
    private volatile boolean started = false;
    private final ConfigurationHolder configurationHolder = new ConfigurationHolder();

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                this.rabbitmqClient.closeConnection(this.connection);
                this.rabbitmqClient.closeChannel(this.channel);
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties properties) throws Exception {
        this.configurationHolder.init();
        this.rabbitmqClient = new RabbitmqClient(this.rabbitmqConnectionFactory);
        this.connection = this.rabbitmqClient.getConnection(this.configurationHolder.getHost(), this.configurationHolder.getUsername(), this.configurationHolder.getPasswd(), this.configurationHolder.getPort(), this.configurationHolder.getVirtualHost());
        this.channel = this.rabbitmqConnectionFactory.createChannel(this.connection);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        try {
            RabbitmqCloudEventWriter writer = new RabbitmqCloudEventWriter();
            RabbitmqCloudEvent rabbitmqCloudEvent = (RabbitmqCloudEvent)writer.writeBinary(cloudEvent);
            byte[] data = RabbitmqCloudEvent.toByteArray(rabbitmqCloudEvent);
            if (data != null) {
                this.rabbitmqClient.publish(this.channel, this.configurationHolder.getExchangeName(), this.configurationHolder.getRoutingKey(), data);
                SendResult sendResult = new SendResult();
                sendResult.setTopic(cloudEvent.getSubject());
                sendResult.setMessageId(cloudEvent.getId());
                sendCallback.onSuccess(sendResult);
            }
        }
        catch (Exception ex) {
            logger.error("[RabbitmqProducer] publish happen exception.", (Throwable)ex);
            sendCallback.onException(OnExceptionContext.builder().topic(cloudEvent.getSubject()).messageId(cloudEvent.getId()).exception(new ConnectorRuntimeException((Throwable)ex)).build());
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        try {
            Optional<byte[]> optionalBytes = ByteArrayUtils.objectToBytes(cloudEvent);
            if (optionalBytes.isPresent()) {
                byte[] data = optionalBytes.get();
                this.rabbitmqClient.publish(this.channel, this.configurationHolder.getExchangeName(), this.configurationHolder.getRoutingKey(), data);
            }
        }
        catch (Exception ex) {
            logger.error("[RabbitmqProducer] sendOneway happen exception.", (Throwable)ex);
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        return false;
    }

    public void checkTopicExist(String topic) throws Exception {
    }

    public void setExtFields() {
    }

    public void setRabbitmqConnectionFactory(RabbitmqConnectionFactory rabbitmqConnectionFactory) {
        this.rabbitmqConnectionFactory = rabbitmqConnectionFactory;
    }
}

