/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;

public class ConfigurationWrapper {
    private static final String CONF_FILE = "rabbitmq-client.properties";
    private static final Properties PROPERTIES = new Properties();

    public static String getProperty(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : PROPERTIES.getProperty(key, null);
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/rabbitmq-client.properties");){
            if (resourceAsStream != null) {
                PROPERTIES.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Load %s file from classpath error", CONF_FILE));
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONF_FILE;
            if (new File(configPath).exists()) {
                PROPERTIES.load(new BufferedReader(new FileReader(configPath)));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", CONF_FILE));
        }
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

