/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.config;

import com.google.common.base.Preconditions;
import com.rabbitmq.client.BuiltinExchangeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.rabbitmq.config.ConfigurationWrapper;

public class ConfigurationHolder {
    public String host;
    public int port;
    public String username;
    public String passwd;
    public String virtualHost;
    public BuiltinExchangeType exchangeType;
    public String exchangeName;
    public String routingKey;
    public String queueName;
    public boolean autoAck;

    public void init() {
        String host = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.host");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)host), (Object)String.format("%s error", "eventMesh.server.rabbitmq.host"));
        this.host = host;
        String port = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.port");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)port), (Object)String.format("%s error", "eventMesh.server.rabbitmq.port"));
        this.port = Integer.parseInt(port);
        String username = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.username");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)username), (Object)String.format("%s error", "eventMesh.server.rabbitmq.username"));
        this.username = username;
        String passwd = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.passwd");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)passwd), (Object)String.format("%s error", "eventMesh.server.rabbitmq.passwd"));
        this.passwd = passwd;
        this.virtualHost = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.virtualHost");
        String exchangeType = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.exchangeType");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)exchangeType), (Object)String.format("%s error", "eventMesh.server.rabbitmq.exchangeType"));
        this.exchangeType = BuiltinExchangeType.valueOf((String)exchangeType);
        String exchangeName = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.exchangeName");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)host), (Object)String.format("%s error", "eventMesh.server.rabbitmq.exchangeName"));
        this.exchangeName = exchangeName;
        String routingKey = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.routingKey");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)routingKey), (Object)String.format("%s error", "eventMesh.server.rabbitmq.routingKey"));
        this.routingKey = routingKey;
        String queueName = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.queueName");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)queueName), (Object)String.format("%s error", "eventMesh.server.rabbitmq.queueName"));
        this.queueName = queueName;
        String autoAck = ConfigurationWrapper.getProperty("eventMesh.server.rabbitmq.autoAck");
        this.autoAck = StringUtils.isNotEmpty((CharSequence)autoAck) && Boolean.parseBoolean(autoAck);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public BuiltinExchangeType getExchangeType() {
        return this.exchangeType;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setExchangeType(BuiltinExchangeType exchangeType) {
        this.exchangeType = exchangeType;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationHolder)) {
            return false;
        }
        ConfigurationHolder other = (ConfigurationHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAutoAck() != other.isAutoAck()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$passwd = this.getPasswd();
        String other$passwd = other.getPasswd();
        if (this$passwd == null ? other$passwd != null : !this$passwd.equals(other$passwd)) {
            return false;
        }
        String this$virtualHost = this.getVirtualHost();
        String other$virtualHost = other.getVirtualHost();
        if (this$virtualHost == null ? other$virtualHost != null : !this$virtualHost.equals(other$virtualHost)) {
            return false;
        }
        BuiltinExchangeType this$exchangeType = this.getExchangeType();
        BuiltinExchangeType other$exchangeType = other.getExchangeType();
        if (this$exchangeType == null ? other$exchangeType != null : !this$exchangeType.equals(other$exchangeType)) {
            return false;
        }
        String this$exchangeName = this.getExchangeName();
        String other$exchangeName = other.getExchangeName();
        if (this$exchangeName == null ? other$exchangeName != null : !this$exchangeName.equals(other$exchangeName)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        return !(this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAutoAck() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $passwd = this.getPasswd();
        result = result * 59 + ($passwd == null ? 43 : $passwd.hashCode());
        String $virtualHost = this.getVirtualHost();
        result = result * 59 + ($virtualHost == null ? 43 : $virtualHost.hashCode());
        BuiltinExchangeType $exchangeType = this.getExchangeType();
        result = result * 59 + ($exchangeType == null ? 43 : $exchangeType.hashCode());
        String $exchangeName = this.getExchangeName();
        result = result * 59 + ($exchangeName == null ? 43 : $exchangeName.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigurationHolder(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", passwd=" + this.getPasswd() + ", virtualHost=" + this.getVirtualHost() + ", exchangeType=" + this.getExchangeType() + ", exchangeName=" + this.getExchangeName() + ", routingKey=" + this.getRoutingKey() + ", queueName=" + this.getQueueName() + ", autoAck=" + this.isAutoAck() + ")";
    }
}

