/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.file;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import org.apache.eventmesh.common.file.FileChangeContext;
import org.apache.eventmesh.common.file.FileChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchFileTask
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchFileTask.class);
    private static final FileSystem FILE_SYSTEM = FileSystems.getDefault();
    private final WatchService watchService;
    private final List<FileChangeListener> fileChangeListeners = new ArrayList<FileChangeListener>();
    private volatile boolean watch = true;
    private final String directoryPath;

    public WatchFileTask(String directoryPath) {
        this.directoryPath = directoryPath;
        Path path = Paths.get(directoryPath, new String[0]);
        if (!path.toFile().exists()) {
            throw new IllegalArgumentException("file directory not exist: " + directoryPath);
        }
        if (!path.toFile().isDirectory()) {
            throw new IllegalArgumentException("must be a file directory : " + directoryPath);
        }
        try {
            WatchService service = FILE_SYSTEM.newWatchService();
            path.register(service, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.watchService = service;
        }
        catch (Throwable ex) {
            throw new UnsupportedOperationException("WatchService registry fail", ex);
        }
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (fileChangeListener != null) {
            this.fileChangeListeners.add(fileChangeListener);
        }
    }

    public void shutdown() {
        this.watch = false;
    }

    @Override
    public void run() {
        while (this.watch) {
            try {
                WatchKey watchKey = this.watchService.take();
                List<WatchEvent<?>> events = watchKey.pollEvents();
                watchKey.reset();
                if (events.isEmpty()) continue;
                for (WatchEvent<?> event : events) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                        LOGGER.warn("[WatchFileTask] file overflow: {}", event.context());
                        continue;
                    }
                    this.precessWatchEvent(event);
                }
            }
            catch (InterruptedException ex) {
                boolean interrupted = Thread.interrupted();
                if (!interrupted || !LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[WatchFileTask] file watch is interrupted");
            }
            catch (Throwable ex) {
                LOGGER.error("[WatchFileTask] an exception occurred during file listening : ", ex);
            }
        }
    }

    private void precessWatchEvent(WatchEvent<?> event) {
        try {
            for (FileChangeListener fileChangeListener : this.fileChangeListeners) {
                FileChangeContext context = new FileChangeContext();
                context.setDirectoryPath(this.directoryPath);
                context.setFileName(event.context().toString());
                context.setWatchEvent(event);
                if (!fileChangeListener.support(context)) continue;
                fileChangeListener.onChanged(context);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("[WatchFileTask] file change event callback error : ", ex);
        }
    }
}

