/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.broker.task;

import io.cloudevents.CloudEvent;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.connector.standalone.broker.StandaloneBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubScribeTask
implements Runnable {
    private String topicName;
    private StandaloneBroker standaloneBroker;
    private EventListener listener;
    private volatile boolean isRunning;
    private AtomicInteger offset;
    private final Logger logger = LoggerFactory.getLogger(SubScribeTask.class);

    public SubScribeTask(String topicName, StandaloneBroker standaloneBroker, EventListener listener) {
        this.topicName = topicName;
        this.standaloneBroker = standaloneBroker;
        this.listener = listener;
        this.isRunning = true;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                CloudEvent message;
                this.logger.debug("execute subscribe task, topic: {}, offset: {}", (Object)this.topicName, (Object)this.offset);
                if (this.offset == null && (message = this.standaloneBroker.getMessage(this.topicName)) != null) {
                    this.offset = message.getExtension("offset") != null ? new AtomicInteger((Integer)message.getExtension("offset")) : new AtomicInteger(0);
                }
                if (this.offset != null && (message = this.standaloneBroker.getMessage(this.topicName, this.offset.get())) != null) {
                    EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                        public void commit(EventMeshAction action) {
                            switch (action) {
                                case CommitMessage: {
                                    SubScribeTask.this.logger.info("message commit, topic: {}, current offset:{}", (Object)SubScribeTask.this.topicName, (Object)SubScribeTask.this.offset.get());
                                    break;
                                }
                                case ReconsumeLater: {
                                    break;
                                }
                                case ManualAck: {
                                    SubScribeTask.this.offset.incrementAndGet();
                                    SubScribeTask.this.logger.info("message ack, topic: {}, current offset:{}", (Object)SubScribeTask.this.topicName, (Object)SubScribeTask.this.offset.get());
                                    break;
                                }
                            }
                        }
                    };
                    this.listener.consume(message, (AsyncConsumeContext)consumeContext);
                }
            }
            catch (Exception ex) {
                this.logger.error("consumer error, topic: {}, offset: {}", new Object[]{this.topicName, this.offset == null ? null : Integer.valueOf(this.offset.get()), ex});
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error("Thread is interrupted, topic: {}, offset: {} thread name: {}", new Object[]{this.topicName, this.offset == null ? null : Integer.valueOf(this.offset.get()), Thread.currentThread().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        this.isRunning = false;
    }
}

