/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.etcd.factory;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import io.etcd.jetcd.options.LeaseOption;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.registry.etcd.factory.EtcdClientWrapper;
import org.apache.eventmesh.registry.etcd.factory.EtcdLeaseId;
import org.apache.eventmesh.registry.etcd.factory.EtcdStreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(EtcdClientFactory.class);
    private static final Map<String, EtcdLeaseId> etcdLeaseIdMap = new ConcurrentHashMap<String, EtcdLeaseId>();

    public static Client createClient(Properties properties) {
        String serverAddr = properties.getProperty("serverAddr");
        String username = properties.getProperty("username");
        String password = properties.getProperty("password");
        EtcdLeaseId etcdLeaseId = etcdLeaseIdMap.get(serverAddr);
        if (Objects.nonNull(etcdLeaseId)) {
            return etcdLeaseId.getClientWrapper();
        }
        ClientBuilder clientBuilder = Client.builder();
        String[] addresses = serverAddr.split(",");
        String[] httpAddress = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i].startsWith("http://")) continue;
            httpAddress[i] = "http://" + addresses[i];
        }
        etcdLeaseId = new EtcdLeaseId();
        try {
            etcdLeaseId.setUrl(serverAddr);
            etcdLeaseId.setClientBuilder(clientBuilder.endpoints(httpAddress));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username})) {
                etcdLeaseId.getClientBuilder().user(ByteSequence.from((byte[])username.getBytes()));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{password})) {
                etcdLeaseId.getClientBuilder().password(ByteSequence.from((byte[])password.getBytes()));
            }
            etcdLeaseId.setClientWrapper(new EtcdClientWrapper(etcdLeaseId.getClientBuilder().build()));
            EtcdClientWrapper client = etcdLeaseId.getClientWrapper();
            long leaseId = ((LeaseGrantResponse)client.getLeaseClient().grant(15L).get()).getID();
            etcdLeaseId.setLeaseId(leaseId);
            EtcdStreamObserver etcdStreamObserver = new EtcdStreamObserver();
            etcdStreamObserver.setEtcdLeaseId(etcdLeaseId);
            etcdLeaseId.setEtcdStreamObserver(etcdStreamObserver);
            client.getLeaseClient().keepAlive(leaseId, (StreamObserver)etcdStreamObserver);
            etcdLeaseIdMap.put(serverAddr, etcdLeaseId);
        }
        catch (Throwable e) {
            logger.error("createClient failed, address: {}", (Object)serverAddr, (Object)e);
            throw new RegistryException("createClient failed", e);
        }
        return etcdLeaseId.getClientWrapper();
    }

    public static void renewalLeaseId(EtcdLeaseId etcdLeaseId) {
        logger.info("renewal of contract. server url: {}", (Object)etcdLeaseId.getUrl());
        EtcdClientWrapper client = etcdLeaseId.getClientWrapper();
        try {
            long ttl = ((LeaseTimeToLiveResponse)client.getLeaseClient().timeToLive(etcdLeaseId.getLeaseId(), LeaseOption.DEFAULT).get()).getTTl();
            if (ttl < 1L) {
                long leaseId = ((LeaseGrantResponse)client.getLeaseClient().grant(15L).get()).getID();
                client.getLeaseClient().keepAlive(leaseId, (StreamObserver)etcdLeaseId.getEtcdStreamObserver());
                etcdLeaseId.setLeaseId(leaseId);
            }
        }
        catch (Throwable e) {
            logger.error("renewal error, server url: {}", (Object)etcdLeaseId.getUrl(), (Object)e);
            client.getLeaseClient().keepAlive(System.currentTimeMillis(), (StreamObserver)etcdLeaseId.getEtcdStreamObserver());
        }
    }

    public static Long getLeaseId(String url) {
        return EtcdClientFactory.getEtcdLeaseId(url).getLeaseId();
    }

    public static EtcdLeaseId getEtcdLeaseId(String url) {
        return etcdLeaseIdMap.get(url);
    }
}

