/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.opentelemetry.api.trace.Span;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.GoodbyeTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.HeartBeatTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.HelloTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.ListenTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.MessageAckTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.MessageTransferTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.RecommendTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.SubscribeTask;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.UnSubscribeTask;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpMessageDispatcher
extends SimpleChannelInboundHandler<Package> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;

    public EventMeshTcpMessageDispatcher(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Package pkg) throws Exception {
        long startTime = System.currentTimeMillis();
        this.validateMsg(pkg);
        this.eventMeshTCPServer.getEventMeshTcpMonitor().getTcpSummaryMetrics().getClient2eventMeshMsgNum().incrementAndGet();
        Command cmd = pkg.getHeader().getCmd();
        try {
            if (this.isNeedTrace(cmd)) {
                pkg.getHeader().getProperties().put("reqc2eventmeshtimestamp", startTime);
                pkg.getHeader().getProperties().put("reqsendeventmeship", this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerIp);
                Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
                pkg.getHeader().getProperties().put("req0sys", session.getClient().getSubsystem());
                pkg.getHeader().getProperties().put("req0ip", session.getClient().getHost());
                pkg.getHeader().getProperties().put("req0idc", session.getClient().getIdc());
                pkg.getHeader().getProperties().put("req0group", session.getClient().getGroup());
            }
            if (cmd.equals((Object)Command.RECOMMEND_REQUEST)) {
                this.messageLogger.info("pkg|c2eventMesh|cmd={}|pkg={}", (Object)cmd, (Object)pkg);
                RecommendTask task = new RecommendTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                this.eventMeshTCPServer.getTaskHandleExecutorService().submit(task);
                return;
            }
            if (cmd.equals((Object)Command.HELLO_REQUEST)) {
                this.messageLogger.info("pkg|c2eventMesh|cmd={}|pkg={}", (Object)cmd, (Object)pkg);
                HelloTask task = new HelloTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                this.eventMeshTCPServer.getTaskHandleExecutorService().submit(task);
                return;
            }
            if (this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx) == null) {
                this.messageLogger.info("pkg|c2eventMesh|cmd={}|pkg={},no session is found", (Object)cmd, (Object)pkg);
                throw new Exception("no session is found");
            }
            this.logMessageFlow(ctx, pkg, cmd);
            if (this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx).getSessionState() == SessionState.CLOSED) {
                throw new Exception("this eventMesh tcp session will be closed, may be reboot or version change!");
            }
            this.dispatch(ctx, pkg, startTime, cmd);
        }
        catch (Exception e) {
            this.logger.error("exception occurred while pkg|cmd={}|pkg={}", new Object[]{cmd, pkg, e});
            if (this.isNeedTrace(cmd)) {
                Span span = TraceUtils.prepareServerSpan(pkg.getHeader().getProperties(), "upstream-eventmesh-server-span", startTime, TimeUnit.MILLISECONDS, false);
                TraceUtils.finishSpanWithException(span, pkg.getHeader().getProperties(), "exception occurred while dispatch pkg", (Throwable)e);
            }
            this.writeToClient(cmd, pkg, ctx, e);
        }
    }

    private boolean isNeedTrace(Command cmd) {
        return this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerTraceEnable && cmd != null && (Command.REQUEST_TO_SERVER == cmd || Command.ASYNC_MESSAGE_TO_SERVER == cmd || Command.BROADCAST_MESSAGE_TO_SERVER == cmd);
    }

    private void writeToClient(Command cmd, Package pkg, ChannelHandlerContext ctx, Exception e) {
        try {
            Package res = new Package();
            res.setHeader(new Header(this.getReplyCommand(cmd), OPStatus.FAIL.getCode().intValue(), e.toString(), pkg.getHeader().getSeq()));
            ctx.writeAndFlush((Object)res);
        }
        catch (Exception ex) {
            this.logger.warn("writeToClient failed", (Throwable)ex);
        }
    }

    private Command getReplyCommand(Command cmd) {
        switch (cmd) {
            case HELLO_REQUEST: {
                return Command.HELLO_RESPONSE;
            }
            case RECOMMEND_REQUEST: {
                return Command.RECOMMEND_RESPONSE;
            }
            case HEARTBEAT_REQUEST: {
                return Command.HEARTBEAT_RESPONSE;
            }
            case SUBSCRIBE_REQUEST: {
                return Command.SUBSCRIBE_RESPONSE;
            }
            case UNSUBSCRIBE_REQUEST: {
                return Command.UNSUBSCRIBE_RESPONSE;
            }
            case LISTEN_REQUEST: {
                return Command.LISTEN_RESPONSE;
            }
            case CLIENT_GOODBYE_REQUEST: {
                return Command.CLIENT_GOODBYE_RESPONSE;
            }
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }

    private void logMessageFlow(ChannelHandlerContext ctx, Package pkg, Command cmd) {
        if (pkg.getBody() instanceof EventMeshMessage) {
            this.messageLogger.info("pkg|c2eventMesh|cmd={}|Msg={}|user={}", new Object[]{cmd, EventMeshUtil.printMqMessage((EventMeshMessage)pkg.getBody()), this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx).getClient()});
        } else {
            this.messageLogger.info("pkg|c2eventMesh|cmd={}|pkg={}|user={}", new Object[]{cmd, pkg, this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx).getClient()});
        }
    }

    private void validateMsg(Package pkg) throws Exception {
        if (pkg == null) {
            throw new Exception("the incoming message is empty.");
        }
        if (pkg.getHeader() == null) {
            this.logger.error("the incoming message does not have a header|pkg={}", (Object)pkg);
            throw new Exception("the incoming message does not have a header.");
        }
        if (pkg.getHeader().getCmd() == null) {
            this.logger.error("the incoming message does not have a command type|pkg={}", (Object)pkg);
            throw new Exception("the incoming message does not have a command type.");
        }
    }

    private void dispatch(ChannelHandlerContext ctx, Package pkg, long startTime, Command cmd) throws Exception {
        AbstractTask task;
        switch (cmd) {
            case HEARTBEAT_REQUEST: {
                task = new HeartBeatTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case CLIENT_GOODBYE_REQUEST: 
            case SERVER_GOODBYE_RESPONSE: {
                task = new GoodbyeTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case SUBSCRIBE_REQUEST: {
                task = new SubscribeTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case UNSUBSCRIBE_REQUEST: {
                task = new UnSubscribeTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case LISTEN_REQUEST: {
                task = new ListenTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case REQUEST_TO_SERVER: 
            case ASYNC_MESSAGE_TO_SERVER: 
            case BROADCAST_MESSAGE_TO_SERVER: 
            case RESPONSE_TO_SERVER: {
                task = new MessageTransferTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            case RESPONSE_TO_CLIENT_ACK: 
            case ASYNC_MESSAGE_TO_CLIENT_ACK: 
            case BROADCAST_MESSAGE_TO_CLIENT_ACK: 
            case REQUEST_TO_CLIENT_ACK: {
                task = new MessageAckTask(pkg, ctx, startTime, this.eventMeshTCPServer);
                break;
            }
            default: {
                throw new Exception("unknown cmd");
            }
        }
        this.eventMeshTCPServer.getTaskHandleExecutorService().submit(task);
    }
}

