/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatProcessor
implements HttpRequestProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public HeartBeatProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.httpLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        HeartbeatRequestHeader heartbeatRequestHeader = (HeartbeatRequestHeader)asyncContext.getRequest().getHeader();
        HeartbeatRequestBody heartbeatRequestBody = (HeartbeatRequestBody)asyncContext.getRequest().getBody();
        HeartbeatResponseHeader heartbeatResponseHeader = HeartbeatResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtils.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)heartbeatRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)heartbeatRequestBody.getClientType()) || StringUtils.isBlank((CharSequence)heartbeatRequestBody.getConsumerGroup()) || CollectionUtils.isEmpty((Collection)heartbeatRequestBody.getHeartbeatEntities())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        ConcurrentHashMap tmp = new ConcurrentHashMap();
        String env = heartbeatRequestHeader.getEnv();
        String idc = heartbeatRequestHeader.getIdc();
        String sys = heartbeatRequestHeader.getSys();
        String ip = heartbeatRequestHeader.getIp();
        String pid = heartbeatRequestHeader.getPid();
        String consumerGroup = heartbeatRequestBody.getConsumerGroup();
        List heartbeatEntities = heartbeatRequestBody.getHeartbeatEntities();
        for (HeartbeatRequestBody.HeartbeatEntity heartbeatEntity : heartbeatEntities) {
            Client client = new Client();
            client.env = env;
            client.idc = idc;
            client.sys = sys;
            client.ip = ip;
            client.pid = pid;
            client.consumerGroup = consumerGroup;
            client.topic = heartbeatEntity.topic;
            client.url = heartbeatEntity.url;
            client.lastUpTime = new Date();
            if (StringUtils.isBlank((CharSequence)client.topic)) continue;
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
                String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                String user = heartbeatRequestHeader.getUsername();
                String pass = heartbeatRequestHeader.getPasswd();
                int requestCode = Integer.parseInt(heartbeatRequestHeader.getCode());
                try {
                    Acl.doAclCheckInHttpHeartbeat(remoteAddr, user, pass, sys, client.topic, requestCode);
                }
                catch (Exception e) {
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                    asyncContext.onComplete(responseEventMeshCommand);
                    this.aclLogger.warn("CLIENT HAS NO PERMISSION,HeartBeatProcessor subscribe failed", (Throwable)e);
                    return;
                }
            }
            if (StringUtils.isBlank((CharSequence)client.url)) continue;
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (tmp.containsKey(groupTopicKey)) {
                ((List)tmp.get(groupTopicKey)).add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            tmp.put(groupTopicKey, clients);
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            for (Map.Entry groupTopicClientMapping : tmp.entrySet()) {
                List<Client> localClientList = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicClientMapping.getKey());
                if (CollectionUtils.isEmpty(localClientList)) {
                    this.eventMeshHTTPServer.localClientInfoMapping.put((String)groupTopicClientMapping.getKey(), (List<Client>)groupTopicClientMapping.getValue());
                    continue;
                }
                List tmpClientList = (List)groupTopicClientMapping.getValue();
                this.supplyClientInfoList(tmpClientList, localClientList);
                this.eventMeshHTTPServer.localClientInfoMapping.put((String)groupTopicClientMapping.getKey(), localClientList);
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

                @Override
                public void onResponse(HttpCommand httpCommand) {
                    try {
                        if (HeartBeatProcessor.this.httpLogger.isDebugEnabled()) {
                            HeartBeatProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                        }
                        HeartBeatProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                        ((HeartBeatProcessor)HeartBeatProcessor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
            asyncContext.onComplete(responseEventMeshCommand, handler);
        }
        catch (Exception e) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(err);
            long endTime = System.currentTimeMillis();
            this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|heartBeatMessageCost={}ms", (Object)(endTime - startTime), (Object)e);
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    private void supplyClientInfoList(List<Client> tmpClientList, List<Client> localClientList) {
        for (Client tmpClient : tmpClientList) {
            boolean isContains = false;
            for (Client localClient : localClientList) {
                if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)tmpClient.url)) continue;
                isContains = true;
                localClient.lastUpTime = tmpClient.lastUpTime;
                break;
            }
            if (isContains) continue;
            localClientList.add(tmpClient);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

