/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPMessageHandler;
import org.apache.eventmesh.runtime.core.protocol.http.push.MessageHandler;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private EventMeshHTTPServer eventMeshHTTPServer;
    private AtomicBoolean started4Persistent = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean started4Broadcast = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean inited4Persistent = new AtomicBoolean(Boolean.FALSE);
    private AtomicBoolean inited4Broadcast = new AtomicBoolean(Boolean.FALSE);
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private ConsumerGroupConf consumerGroupConf;
    private MQConsumerWrapper persistentMqConsumer;
    private MQConsumerWrapper broadcastMqConsumer;
    private MessageHandler httpMessageHandler;

    public EventMeshConsumer(EventMeshHTTPServer eventMeshHTTPServer, ConsumerGroupConf consumerGroupConf) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.consumerGroupConf = consumerGroupConf;
        this.persistentMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshConnectorPluginType);
        this.broadcastMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshConnectorPluginType);
    }

    public synchronized void init() throws Exception {
        this.httpMessageHandler = new HTTPMessageHandler(this);
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        keyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster));
        this.persistentMqConsumer.init(keyValue);
        EventListener clusterEventListener = new EventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void consume(CloudEvent event, AsyncConsumeContext context) {
                block11: {
                    protocolVersion = Objects.requireNonNull(event.getSpecVersion()).toString();
                    span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "downstream-eventmesh-server-span", false);
                    try {
                        topic = event.getSubject();
                        bizSeqNo = (String)event.getExtension("searchkeys");
                        uniqueId = (String)event.getExtension("rmbuniqid");
                        event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", EventMeshConsumer.access$000((EventMeshConsumer)EventMeshConsumer.this).getEventMeshHttpConfiguration().eventMeshServerIp).build();
                        if (EventMeshConsumer.this.messageLogger.isDebugEnabled()) {
                            EventMeshConsumer.this.messageLogger.debug("message|mq2eventMesh|topic={}|event={}", (Object)topic, (Object)event);
                        } else {
                            EventMeshConsumer.this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                        }
                        currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroupTopicConf(), (Object)topic, null);
                        eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                        if (currentTopicConfig != null) ** GOTO lbl-1000
                        EventMeshConsumer.this.logger.error("no topicConfig found, consumerGroup:{} topic:{}", (Object)EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroup(), (Object)topic);
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                            return;
                        }
                        catch (Exception var10_10) {
                            subscriptionItem = EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroupTopicConf().get(topic).getSubscriptionItem();
                            handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroup(), EventMeshConsumer.this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), EventMeshConsumer.access$100(EventMeshConsumer.this), EventMeshConsumer.access$000(EventMeshConsumer.this), bizSeqNo, uniqueId, currentTopicConfig);
                            if (EventMeshConsumer.access$200(EventMeshConsumer.this).handle(handleMsgContext)) {
                                eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                                break block11;
                            }
                            try {
                                EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            }
                            catch (Exception var12_13) {
                                // empty catch block
                            }
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                        }
                    }
                    finally {
                        TraceUtils.finishSpan(span, event);
                    }
                }
            }
        };
        this.persistentMqConsumer.registerEventListener(clusterEventListener);
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        EventListener broadcastEventListener = new EventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void consume(CloudEvent event, AsyncConsumeContext context) {
                block11: {
                    protocolVersion = Objects.requireNonNull(event.getSpecVersion()).toString();
                    span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "downstream-eventmesh-server-span", false);
                    try {
                        event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", EventMeshConsumer.access$000((EventMeshConsumer)EventMeshConsumer.this).getEventMeshHttpConfiguration().eventMeshServerIp).build();
                        topic = event.getSubject();
                        bizSeqNo = event.getExtension("searchkeys").toString();
                        uniqueId = event.getExtension("rmbuniqid").toString();
                        if (EventMeshConsumer.this.messageLogger.isDebugEnabled()) {
                            EventMeshConsumer.this.messageLogger.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
                        } else {
                            EventMeshConsumer.this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                        }
                        currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroupTopicConf(), (Object)topic, null);
                        eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                        if (currentTopicConfig != null) ** GOTO lbl-1000
                        EventMeshConsumer.this.logger.error("no topicConfig found, consumerGroup:{} topic:{}", (Object)EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroup(), (Object)topic);
                        try {
                            EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                            return;
                        }
                        catch (Exception var10_10) {
                            subscriptionItem = EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroupTopicConf().get(topic).getSubscriptionItem();
                            handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), EventMeshConsumer.access$100(EventMeshConsumer.this).getConsumerGroup(), EventMeshConsumer.this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), EventMeshConsumer.access$100(EventMeshConsumer.this), EventMeshConsumer.access$000(EventMeshConsumer.this), bizSeqNo, uniqueId, currentTopicConfig);
                            if (EventMeshConsumer.access$200(EventMeshConsumer.this).handle(handleMsgContext)) {
                                eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                                break block11;
                            }
                            try {
                                EventMeshConsumer.this.sendMessageBack(event, uniqueId, bizSeqNo);
                            }
                            catch (Exception var12_13) {
                                // empty catch block
                            }
                            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                        }
                    }
                    finally {
                        TraceUtils.finishSpan(span, event);
                    }
                }
            }
        };
        this.broadcastMqConsumer.registerEventListener(broadcastEventListener);
        this.inited4Persistent.compareAndSet(false, true);
        this.inited4Broadcast.compareAndSet(false, true);
        this.logger.info("EventMeshConsumer [{}] inited.............", (Object)this.consumerGroupConf.getConsumerGroup());
    }

    public synchronized void start() throws Exception {
        this.persistentMqConsumer.start();
        this.started4Persistent.compareAndSet(false, true);
        this.broadcastMqConsumer.start();
        this.started4Broadcast.compareAndSet(false, true);
    }

    public void subscribe(String topic, SubscriptionItem subscriptionItem) throws Exception {
        if (!SubscriptionMode.BROADCASTING.equals((Object)subscriptionItem.getMode())) {
            this.persistentMqConsumer.subscribe(topic);
        } else {
            this.broadcastMqConsumer.subscribe(topic);
        }
    }

    public void unsubscribe(String topic, SubscriptionMode subscriptionMode) throws Exception {
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.unsubscribe(topic);
        } else {
            this.persistentMqConsumer.unsubscribe(topic);
        }
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.started4Persistent.compareAndSet(true, false);
        this.broadcastMqConsumer.shutdown();
        this.started4Broadcast.compareAndSet(true, false);
    }

    public void updateOffset(String topic, SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) {
        if (SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.updateOffset(events, context);
        } else {
            this.persistentMqConsumer.updateOffset(events, context);
        }
    }

    public ConsumerGroupConf getConsumerGroupConf() {
        return this.consumerGroupConf;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public void sendMessageBack(CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer sendMessageBack = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(this.consumerGroupConf.getConsumerGroup());
        if (sendMessageBack == null) {
            this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, sendMessageBack, this.eventMeshHTTPServer);
        sendMessageBack.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                EventMeshConsumer.this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqno:{}, uniqueId:{}", new Object[]{EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            }
        });
    }

    static /* synthetic */ EventMeshHTTPServer access$000(EventMeshConsumer x0) {
        return x0.eventMeshHTTPServer;
    }

    static /* synthetic */ MessageHandler access$200(EventMeshConsumer x0) {
        return x0.httpMessageHandler;
    }
}

