/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.ReplyMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.SubscribeStreamProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.UnsubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerService
extends ConsumerServiceGrpc.ConsumerServiceImplBase {
    private final Logger logger = LoggerFactory.getLogger(ConsumerService.class);
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final ThreadPoolExecutor subscribeThreadPoolExecutor;
    private final ThreadPoolExecutor replyThreadPoolExecutor;

    public ConsumerService(EventMeshGrpcServer eventMeshGrpcServer, ThreadPoolExecutor subscribeThreadPoolExecutor, ThreadPoolExecutor replyThreadPoolExecutor) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.subscribeThreadPoolExecutor = subscribeThreadPoolExecutor;
        this.replyThreadPoolExecutor = replyThreadPoolExecutor;
    }

    public void subscribe(Subscription request, StreamObserver<Response> responseObserver) {
        this.logger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"subscribe", "grpc", request.getHeader().getIp(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
        EventEmitter<Response> emitter = new EventEmitter<Response>(responseObserver);
        this.subscribeThreadPoolExecutor.submit(() -> {
            SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this.eventMeshGrpcServer);
            try {
                subscribeProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR.getRetCode(), StatusCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg(), e});
                ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    public StreamObserver<Subscription> subscribeStream(StreamObserver<SimpleMessage> responseObserver) {
        final EventEmitter<SimpleMessage> emitter = new EventEmitter<SimpleMessage>(responseObserver);
        return new StreamObserver<Subscription>(){

            public void onNext(Subscription subscription) {
                if (!subscription.getSubscriptionItemsList().isEmpty()) {
                    ConsumerService.this.logger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"subscribeStream", "grpc", subscription.getHeader().getIp(), ((ConsumerService)ConsumerService.this).eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
                    ConsumerService.this.handleSubscriptionStream(subscription, emitter);
                } else {
                    ConsumerService.this.logger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"reply-to-server", "grpc", subscription.getHeader().getIp(), ((ConsumerService)ConsumerService.this).eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
                    ConsumerService.this.handleSubscribeReply(subscription, emitter);
                }
            }

            public void onError(Throwable t) {
                ConsumerService.this.logger.error("Receive error from client: " + t.getMessage());
                emitter.onCompleted();
            }

            public void onCompleted() {
                ConsumerService.this.logger.info("Client finish sending messages");
                emitter.onCompleted();
            }
        };
    }

    private void handleSubscriptionStream(Subscription request, EventEmitter<SimpleMessage> emitter) {
        this.subscribeThreadPoolExecutor.submit(() -> {
            SubscribeStreamProcessor streamProcessor = new SubscribeStreamProcessor(this.eventMeshGrpcServer);
            try {
                streamProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), e});
                ServiceUtils.sendStreamRespAndDone(request.getHeader(), StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    private void handleSubscribeReply(Subscription subscription, EventEmitter<SimpleMessage> emitter) {
        this.replyThreadPoolExecutor.submit(() -> {
            ReplyMessageProcessor replyMessageProcessor = new ReplyMessageProcessor(this.eventMeshGrpcServer);
            try {
                replyMessageProcessor.process(this.buildSimpleMessage(subscription), emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), e});
                ServiceUtils.sendStreamRespAndDone(subscription.getHeader(), StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    private SimpleMessage buildSimpleMessage(Subscription subscription) {
        Subscription.Reply reply = subscription.getReply();
        return SimpleMessage.newBuilder().setHeader(subscription.getHeader()).setProducerGroup(reply.getProducerGroup()).setContent(reply.getContent()).setUniqueId(reply.getUniqueId()).setSeqNum(reply.getSeqNum()).setTopic(reply.getTopic()).setTtl(reply.getTtl()).putAllProperties(reply.getPropertiesMap()).build();
    }

    public void unsubscribe(Subscription request, StreamObserver<Response> responseObserver) {
        this.logger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"unsubscribe", "grpc", request.getHeader().getIp(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
        EventEmitter<Response> emitter = new EventEmitter<Response>(responseObserver);
        this.subscribeThreadPoolExecutor.submit(() -> {
            UnsubscribeProcessor unsubscribeProcessor = new UnsubscribeProcessor(this.eventMeshGrpcServer);
            try {
                unsubscribeProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), StatusCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg(), e});
                ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_UNSUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }
}

