/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.plugin;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.runtime.core.plugin.MQWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProducerWrapper
extends MQWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Producer meshMQProducer;

    public MQProducerWrapper(String connectorPluginType) {
        this.meshMQProducer = ConnectorPluginFactory.getMeshMQProducer((String)connectorPluginType);
        if (this.meshMQProducer == null) {
            this.logger.error("can't load the meshMQProducer plugin, please check.");
            throw new RuntimeException("doesn't load the meshMQProducer plugin, please check.");
        }
    }

    public synchronized void init(Properties keyValue) throws Exception {
        if (this.inited.get()) {
            return;
        }
        this.meshMQProducer.init(keyValue);
        this.inited.compareAndSet(false, true);
    }

    public synchronized void start() throws Exception {
        if (this.started.get()) {
            return;
        }
        this.meshMQProducer.start();
        this.started.compareAndSet(false, true);
    }

    public synchronized void shutdown() throws Exception {
        if (!this.inited.get()) {
            return;
        }
        if (!this.started.get()) {
            return;
        }
        this.meshMQProducer.shutdown();
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
    }

    public void send(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        this.meshMQProducer.publish(cloudEvent, sendCallback);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.meshMQProducer.request(cloudEvent, rrCallback, timeout);
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        return this.meshMQProducer.reply(cloudEvent, sendCallback);
    }

    public Producer getMeshMQProducer() {
        return this.meshMQProducer;
    }
}

