/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.cloudevents.CloudEvent;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.trace.TraceUtils;

public class HTTPTrace {
    public boolean useTrace;

    public HTTPTrace(boolean useTrace) {
        this.useTrace = useTrace;
    }

    public TraceOperation getTraceOperation(HttpRequest httpRequest, Channel channel, boolean traceEnabled) {
        Map<String, Object> headerMap = this.parseHttpHeader(httpRequest);
        Span span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
        return new TraceOperation(span, null, traceEnabled);
    }

    private Map<String, Object> parseHttpHeader(HttpRequest fullReq) {
        HashMap<String, Object> headerParam = new HashMap<String, Object>();
        for (String key : fullReq.headers().names()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_TYPE.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.ACCEPT_ENCODING.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_LENGTH.toString(), (CharSequence)key)) continue;
            headerParam.put(key, fullReq.headers().get(key));
        }
        return headerParam;
    }

    public class TraceOperation {
        private Span span;
        private TraceOperation childTraceOperation;
        private boolean traceEnabled;

        public void endTrace(CloudEvent ce) {
            if (!HTTPTrace.this.useTrace) {
                return;
            }
            if (this.childTraceOperation != null) {
                this.childTraceOperation.endTrace(ce);
            }
            try (Scope ignored = this.span.makeCurrent();){
                TraceUtils.finishSpan(this.span, ce);
            }
        }

        public void exceptionTrace(@Nullable Throwable ex, Map<String, Object> map) {
            if (!HTTPTrace.this.useTrace) {
                return;
            }
            if (this.childTraceOperation != null) {
                this.childTraceOperation.exceptionTrace(ex, map);
            }
            try (Scope ignored = this.span.makeCurrent();){
                TraceUtils.finishSpanWithException(this.span, map, ex.getMessage(), ex);
            }
        }

        public void endLatestTrace(CloudEvent ce) {
            if (this.childTraceOperation != null) {
                TraceOperation traceOperation = this.childTraceOperation.getChildTraceOperation();
                this.childTraceOperation.setChildTraceOperation(null);
                this.childTraceOperation.endTrace(ce);
                this.childTraceOperation = traceOperation;
            }
        }

        public void exceptionLatestTrace(@Nullable Throwable ex, Map<String, Object> traceMap) {
            if (this.childTraceOperation != null) {
                TraceOperation traceOperation = this.childTraceOperation.getChildTraceOperation();
                this.childTraceOperation.setChildTraceOperation(null);
                this.childTraceOperation.exceptionTrace(ex, traceMap);
                this.childTraceOperation = traceOperation;
            }
        }

        public TraceOperation createClientTraceOperation(Map<String, Object> map, String spanName, boolean isSpanFinishInOtherThread) {
            TraceOperation traceOperation = new TraceOperation(TraceUtils.prepareClientSpan(map, spanName, isSpanFinishInOtherThread), null, this.traceEnabled);
            this.setChildTraceOperation(traceOperation);
            return traceOperation;
        }

        public void setChildTraceOperation(TraceOperation traceOperation) {
            if (this.childTraceOperation != null) {
                this.childTraceOperation.setChildTraceOperation(traceOperation);
            }
            this.childTraceOperation = traceOperation;
        }

        public TraceOperation(Span span, TraceOperation childTraceOperation, boolean traceEnabled) {
            this.span = span;
            this.childTraceOperation = childTraceOperation;
            this.traceEnabled = traceEnabled;
        }

        public Span getSpan() {
            return this.span;
        }

        public TraceOperation getChildTraceOperation() {
            return this.childTraceOperation;
        }

        public boolean isTraceEnabled() {
            return this.traceEnabled;
        }
    }
}

