/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.connector.ConnectorResource;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.runtime.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public EventMeshHTTPServer eventMeshHTTPServer;
    private EventMeshTCPServer eventMeshTCPServer;
    private EventMeshGrpcServer eventMeshGrpcServer;
    private EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private EventMeshTCPConfiguration eventMeshTcpConfiguration;
    private Acl acl;
    private Registry registry;
    private static Trace trace;
    private ConnectorResource connectorResource;
    private ServiceState serviceState;

    public EventMeshServer(EventMeshHTTPConfiguration eventMeshHttpConfiguration, EventMeshTCPConfiguration eventMeshTcpConfiguration, EventMeshGrpcConfiguration eventMeshGrpcConfiguration) {
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.eventMeshTcpConfiguration = eventMeshTcpConfiguration;
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
        this.acl = new Acl();
        this.registry = new Registry();
        trace = new Trace(eventMeshHttpConfiguration.eventMeshServerTraceEnable);
        this.connectorResource = new ConnectorResource();
        ConfigurationContextUtil.putIfAbsent((String)"TCP", (CommonConfiguration)eventMeshTcpConfiguration);
        ConfigurationContextUtil.putIfAbsent((String)"GRPC", (CommonConfiguration)eventMeshGrpcConfiguration);
        ConfigurationContextUtil.putIfAbsent((String)"HTTP", (CommonConfiguration)eventMeshHttpConfiguration);
    }

    public void init() throws Exception {
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.init(this.eventMeshHttpConfiguration.eventMeshSecurityPluginType);
        }
        if (this.eventMeshTcpConfiguration != null && this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled && this.eventMeshTcpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.init(this.eventMeshTcpConfiguration.eventMeshRegistryPluginType);
        }
        if (this.eventMeshGrpcConfiguration != null && this.eventMeshGrpcConfiguration.eventMeshServerRegistryEnable) {
            this.registry.init(this.eventMeshGrpcConfiguration.eventMeshRegistryPluginType);
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.init(this.eventMeshHttpConfiguration.eventMeshRegistryPluginType);
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerTraceEnable) {
            trace.init(this.eventMeshHttpConfiguration.eventMeshTracePluginType);
        }
        this.connectorResource.init(this.eventMeshHttpConfiguration.eventMeshConnectorPluginType);
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer = new EventMeshGrpcServer(this.eventMeshGrpcConfiguration, this.registry);
            this.eventMeshGrpcServer.init();
        }
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHTTPServer = new EventMeshHTTPServer(this, this.eventMeshHttpConfiguration);
            this.eventMeshHTTPServer.init();
        }
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTCPServer = new EventMeshTCPServer(this, this.eventMeshTcpConfiguration, this.registry);
            if (this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled) {
                this.eventMeshTCPServer.init();
            }
        }
        String eventStore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        this.logger.info("eventStore : {}", (Object)eventStore);
        this.serviceState = ServiceState.INITED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void start() throws Exception {
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.start();
        }
        if (this.eventMeshTcpConfiguration != null && this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled && this.eventMeshTcpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.start();
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.start();
        }
        if (this.eventMeshGrpcConfiguration != null && this.eventMeshGrpcConfiguration.eventMeshServerRegistryEnable) {
            this.registry.start();
        }
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.start();
        }
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHTTPServer.start();
        }
        if (this.eventMeshTcpConfiguration != null && this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.start();
        }
        this.serviceState = ServiceState.RUNNING;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPING;
        this.logger.info("server state:{}", (Object)this.serviceState);
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHTTPServer.shutdown();
        }
        if (this.eventMeshTcpConfiguration != null && this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.shutdown();
        }
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.shutdown();
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.shutdown();
        }
        if (this.eventMeshTcpConfiguration != null && this.eventMeshTcpConfiguration.eventMeshTcpServerEnabled && this.eventMeshTcpConfiguration.eventMeshServerRegistryEnable) {
            this.registry.shutdown();
        }
        if (this.eventMeshGrpcConfiguration != null && this.eventMeshGrpcConfiguration.eventMeshServerRegistryEnable) {
            this.registry.shutdown();
        }
        this.connectorResource.release();
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.shutdown();
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerTraceEnable) {
            trace.shutdown();
        }
        ConfigurationContextUtil.clear();
        this.serviceState = ServiceState.STOPED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public EventMeshGrpcServer getEventMeshGrpcServer() {
        return this.eventMeshGrpcServer;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public static Trace getTrace() {
        return trace;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

