/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.eventmesh.admin.rocketmq.util.JsonUtils;
import org.apache.eventmesh.admin.rocketmq.util.NetUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWebHookConfigByManufacturerHandler
implements HttpHandler {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebHookConfigOperation operation;

    public QueryWebHookConfigByManufacturerHandler(WebHookConfigOperation operation) {
        this.operation = operation;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(200, 0L);
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        String requestBody = NetUtils.parsePostBody((HttpExchange)httpExchange);
        JsonNode node = JsonUtils.getJsonNode((String)requestBody);
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.toObject((String)node.get("webHookConfig").toString(), WebHookConfig.class);
        Integer pageNum = Integer.parseInt(node.get("pageNum").toString());
        Integer pageSize = Integer.parseInt(node.get("pageSize").toString());
        try (OutputStream out = httpExchange.getResponseBody();){
            List result = this.operation.queryWebHookConfigByManufacturer(webHookConfig, pageNum, pageSize);
            out.write(JsonUtils.toJson((Object)result).getBytes());
        }
        catch (Exception e) {
            this.logger.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

