/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.junit.rules.ExternalResource;

public class TextFromStandardInputStream
extends ExternalResource {
    private final SystemInMock systemInMock = new SystemInMock();
    private InputStream originalIn;

    public static TextFromStandardInputStream emptyStandardInputStream() {
        return new TextFromStandardInputStream("");
    }

    @Deprecated
    public TextFromStandardInputStream(String text) {
        this.provideText(text);
    }

    @Deprecated
    public void provideText(String ... texts) {
        this.systemInMock.provideText(this.join(texts));
    }

    public void provideLines(String ... lines) {
        this.systemInMock.provideText(this.joinLines(lines));
    }

    public void throwExceptionOnInputEnd(IOException exception) {
        this.systemInMock.throwExceptionOnInputEnd(exception);
    }

    public void throwExceptionOnInputEnd(RuntimeException exception) {
        this.systemInMock.throwExceptionOnInputEnd(exception);
    }

    private String join(String[] texts) {
        StringBuilder sb = new StringBuilder();
        for (String text : texts) {
            sb.append(text);
        }
        return sb.toString();
    }

    private String joinLines(String[] lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    protected void before() throws Throwable {
        this.originalIn = System.in;
        System.setIn(this.systemInMock);
    }

    protected void after() {
        System.setIn(this.originalIn);
    }

    private static class SystemInMock
    extends InputStream {
        private StringReader currentReader;
        private IOException ioException;
        private RuntimeException runtimeException;

        private SystemInMock() {
        }

        void provideText(String text) {
            this.currentReader = new StringReader(text);
        }

        void throwExceptionOnInputEnd(IOException exception) {
            if (this.runtimeException != null) {
                throw new IllegalStateException("You cannot call throwExceptionOnInputEnd(IOException) because throwExceptionOnInputEnd(RuntimeException) has already been called.");
            }
            this.ioException = exception;
        }

        void throwExceptionOnInputEnd(RuntimeException exception) {
            if (this.ioException != null) {
                throw new IllegalStateException("You cannot call throwExceptionOnInputEnd(RuntimeException) because throwExceptionOnInputEnd(IOException) has already been called.");
            }
            this.runtimeException = exception;
        }

        public int read() throws IOException {
            int character = this.currentReader.read();
            if (character == -1) {
                this.handleEmptyReader();
            }
            return character;
        }

        private void handleEmptyReader() throws IOException {
            if (this.ioException != null) {
                throw this.ioException;
            }
            if (this.runtimeException != null) {
                throw this.runtimeException;
            }
        }

        public int read(byte[] buffer, int offset, int len) throws IOException {
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0 || len > buffer.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            return this.readNextLine(buffer, offset, len);
        }

        private int readNextLine(byte[] buffer, int offset, int len) throws IOException {
            byte read;
            int i;
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            buffer[offset] = (byte)c;
            for (i = 1; i < len && !this.isCompleteLineWritten(buffer, i - 1) && (read = (byte)this.read()) != -1; ++i) {
                buffer[offset + i] = read;
            }
            return i;
        }

        private boolean isCompleteLineWritten(byte[] buffer, int indexLastByteWritten) {
            byte[] separator = System.getProperty("line.separator").getBytes(Charset.defaultCharset());
            int indexFirstByteOfSeparator = indexLastByteWritten - separator.length + 1;
            return indexFirstByteOfSeparator >= 0 && this.contains(buffer, separator, indexFirstByteOfSeparator);
        }

        private boolean contains(byte[] array, byte[] pattern, int indexStart) {
            for (int i = 0; i < pattern.length; ++i) {
                if (array[indexStart + i] == pattern[i]) continue;
                return false;
            }
            return true;
        }
    }
}

