/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.util.Condition;
import org.apache.rocketmq.test.util.TestUtil;
import org.apache.rocketmq.test.util.VerifyUtils;

public class MQWait {
    private static Logger logger = Logger.getLogger(MQWait.class);

    public static boolean waitConsumeAll(int timeoutMills, Collection<Object> allSendMsgs, AbstractListener ... listeners) {
        boolean recvAll = false;
        long startTime = System.currentTimeMillis();
        ArrayList<Object> noDupMsgs = new ArrayList<Object>();
        while (!recvAll) {
            if (System.currentTimeMillis() - startTime < (long)timeoutMills) {
                noDupMsgs.clear();
                try {
                    for (AbstractListener listener : listeners) {
                        Collection<Object> recvMsgs = Collections.synchronizedCollection(listener.getAllUndupMsgBody());
                        noDupMsgs.addAll(VerifyUtils.getFilterdMessage(allSendMsgs, recvMsgs));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Truth.assertThat(noDupMsgs).containsAllIn(allSendMsgs);
                    recvAll = true;
                    break;
                }
                catch (Throwable throwable) {
                    TestUtil.waitForMonment(500L);
                    continue;
                }
            }
            logger.error((Object)String.format("timeout but still not receive all messages,expectSize[%s],realSize[%s]", allSendMsgs.size(), noDupMsgs.size()));
            break;
        }
        return recvAll;
    }

    public static void setCondition(Condition condition, int waitTimeMills, int intervalMills) {
        long startTime = System.currentTimeMillis();
        while (!condition.meetCondition()) {
            if (System.currentTimeMillis() - startTime > (long)waitTimeMills) {
                logger.error((Object)"time out,but contidion still not meet!");
                break;
            }
            TestUtil.waitForMonment(intervalMills);
        }
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        MQWait.setCondition(new Condition(){
            int i = 0;

            @Override
            public boolean meetCondition() {
                ++this.i;
                return this.i == 100;
            }
        }, 10000, 200);
    }
}

