/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.webhook.admin.FileWebHookConfigOperation;
import org.apache.eventmesh.webhook.admin.NacosWebHookConfigOperation;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminWebHookConfigOperationManage {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, Class<? extends WebHookConfigOperation>> map = new HashMap<String, Class<? extends WebHookConfigOperation>>();
    private ConfigurationWrapper configurationWrapper;
    private WebHookConfigOperation webHookConfigOperation;

    public void setConfigurationWrapper(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public WebHookConfigOperation getWebHookConfigOperation() {
        return this.webHookConfigOperation;
    }

    public void init() throws Exception {
        if (!this.configurationWrapper.getBoolProp("eventMesh.webHook.admin.start", false)) {
            return;
        }
        String operationMode = this.configurationWrapper.getProp("eventMesh.webHook.operationMode");
        if (!map.containsKey(operationMode)) {
            throw new IllegalStateException("operationMode is not supported.");
        }
        Constructor<? extends WebHookConfigOperation> constructor = map.get(operationMode).getDeclaredConstructor(Properties.class);
        constructor.setAccessible(true);
        try {
            Properties properties = this.configurationWrapper.getPropertiesByConfig("eventMesh.webHook." + operationMode + "Mode", true);
            this.logger.info("operationMode is {}  properties is {} ", (Object)operationMode, (Object)properties);
            this.webHookConfigOperation = constructor.newInstance(properties);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.logger.error("can't find WebHookConfigOperation implementation");
            throw new Exception("can't find WebHookConfigOperation implementation");
        }
    }

    static {
        map.put("file", FileWebHookConfigOperation.class);
        map.put("nacos", NacosWebHookConfigOperation.class);
    }
}

