/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.protocol;

import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.receive.ManufacturerProtocol;
import org.apache.eventmesh.webhook.receive.WebHookRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubProtocol
implements ManufacturerProtocol {
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getManufacturerName() {
        return "github";
    }

    @Override
    public void execute(WebHookRequest webHookRequest, WebHookConfig webHookConfig, Map<String, String> header) throws Exception {
        String fromSignature = header.get("X-Hub-Signature-256");
        if (!this.isValid(fromSignature, webHookRequest.getData(), webHookConfig.getSecret()).booleanValue()) {
            throw new Exception("webhook-GithubProtocol authenticate failed");
        }
        try {
            webHookRequest.setManufacturerEventId(header.get("X-GitHub-Delivery"));
            webHookRequest.setManufacturerEventName(webHookConfig.getManufacturerEventName());
            webHookRequest.setManufacturerSource(this.getManufacturerName());
        }
        catch (Exception e) {
            throw new Exception("webhook-GithubProtocol parse failed");
        }
    }

    private Boolean isValid(String fromSignature, byte[] data, String secret) {
        String hash = "sha256=";
        try {
            Mac sha = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha.init(secretKey);
            byte[] bytes = sha.doFinal(data);
            hash = hash + this.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            this.logger.error("Error HmacSHA256", (Throwable)e);
        }
        return hash.equals(fromSignature);
    }

    private String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }
}

