/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookOperationConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookFileListener {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private String filePath;
    private Map<String, WebHookConfig> cacheWebHookConfig;
    private final Set<String> pathSet = new LinkedHashSet<String>();
    private final Map<WatchKey, String> watchKeyPathMap = new HashMap<WatchKey, String>();

    public WebhookFileListener() {
    }

    public WebhookFileListener(String filePath, Map<String, WebHookConfig> cacheWebHookConfig) throws FileNotFoundException {
        this.filePath = WebHookOperationConstant.getFilePath((String)filePath);
        this.cacheWebHookConfig = cacheWebHookConfig;
        this.filePatternInit();
    }

    public void filePatternInit() {
        File webHookFileDir = new File(this.filePath);
        if (!webHookFileDir.exists()) {
            webHookFileDir.mkdirs();
        } else {
            this.readFiles(webHookFileDir);
        }
        this.fileWatchRegister();
    }

    public void readFiles(File file) {
        File[] fs = file.listFiles();
        for (File f : Objects.requireNonNull(fs)) {
            if (f.isDirectory()) {
                this.readFiles(f);
                continue;
            }
            if (!f.isFile()) continue;
            this.cacheInit(f);
        }
    }

    public void cacheInit(File webhookConfigFile) {
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(webhookConfigFile)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                fileContent.append(line);
            }
        }
        catch (IOException e) {
            this.logger.error("cacheInit failed", (Throwable)e);
        }
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.deserialize((String)fileContent.toString(), WebHookConfig.class);
        this.cacheWebHookConfig.put(webHookConfig.getCallbackPath(), webHookConfig);
    }

    public void fileWatchRegister() {
        ExecutorService cachedThreadPool = Executors.newFixedThreadPool(1);
        cachedThreadPool.execute(() -> {
            WatchKey key;
            File root = new File(this.filePath);
            this.loopDirInsertToSet(root, this.pathSet);
            WatchService service = null;
            try {
                service = FileSystems.getDefault().newWatchService();
            }
            catch (Exception e) {
                this.logger.error("getWatchService failed.", (Throwable)e);
            }
            for (String path : this.pathSet) {
                WatchKey key2 = null;
                try {
                    key2 = Paths.get(path, new String[0]).register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                }
                catch (IOException e) {
                    this.logger.error("registerWatchKey failed", (Throwable)e);
                }
                this.watchKeyPathMap.put(key2, path);
            }
            do {
                key = null;
                try {
                    assert (service != null);
                    key = service.take();
                }
                catch (InterruptedException e) {
                    this.logger.error("Interrupted", (Throwable)e);
                }
                assert (key != null);
                for (WatchEvent<?> event : key.pollEvents()) {
                    String flashPath = this.watchKeyPathMap.get(key);
                    if (flashPath.equals(this.filePath)) {
                        if (StandardWatchEventKinds.ENTRY_CREATE != event.kind()) continue;
                        try {
                            key = Paths.get(this.filePath + event.context(), new String[0]).register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                        }
                        catch (IOException e) {
                            this.logger.error("registerWatchKey failed", (Throwable)e);
                        }
                        this.watchKeyPathMap.put(key, this.filePath + event.context());
                        continue;
                    }
                    this.cacheInit(new File(flashPath + event.context()));
                }
            } while (key.reset());
        });
    }

    private void loopDirInsertToSet(File parent, Set<String> pathSet) {
        if (!parent.isDirectory()) {
            return;
        }
        pathSet.add(parent.getPath());
        for (File child : Objects.requireNonNull(parent.listFiles())) {
            this.loopDirInsertToSet(child, pathSet);
        }
    }
}

