/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.WebhookProtocolTransportObject;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.receive.ManufacturerProtocol;
import org.apache.eventmesh.webhook.receive.WebHookMQProducer;
import org.apache.eventmesh.webhook.receive.WebHookRequest;
import org.apache.eventmesh.webhook.receive.protocol.ProtocolManage;
import org.apache.eventmesh.webhook.receive.storage.HookConfigOperationManage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookController {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProtocolManage protocolManage = new ProtocolManage();
    private HookConfigOperationManage hookConfigOperationManage;
    private WebHookMQProducer webHookMQProducer;
    private ProtocolAdaptor<ProtocolTransportObject> protocolAdaptor;
    private ConfigurationWrapper configurationWrapper;

    public void init() throws Exception {
        this.webHookMQProducer = new WebHookMQProducer(this.configurationWrapper.getProp("eventMesh.webHook.producer.connector"));
        this.hookConfigOperationManage = new HookConfigOperationManage(this.configurationWrapper);
        this.protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)"webhookProtocolAdaptor");
    }

    public void execute(String path, Map<String, String> header, byte[] body) throws Exception {
        WebHookConfig webHookConfig = new WebHookConfig();
        webHookConfig.setCallbackPath(path);
        webHookConfig = this.hookConfigOperationManage.queryWebHookConfigById(webHookConfig);
        if (webHookConfig == null) {
            throw new Exception("No matching webhookConfig.");
        }
        if (!Objects.equals(webHookConfig.getContentType(), header.get("content-type"))) {
            throw new Exception("http request header content-type value is mismatch. current value " + header.get("content-type"));
        }
        String manufacturerName = webHookConfig.getManufacturerName();
        ManufacturerProtocol protocol = this.protocolManage.getManufacturerProtocol(manufacturerName);
        WebHookRequest webHookRequest = new WebHookRequest();
        webHookRequest.setData(body);
        try {
            protocol.execute(webHookRequest, webHookConfig, header);
        }
        catch (Exception e) {
            throw new Exception("Webhook Message Parse Failed.");
        }
        String cloudEventId = "uuid".equals(webHookConfig.getCloudEventIdGenerateMode()) ? UUID.randomUUID().toString() : webHookRequest.getManufacturerEventId();
        String eventType = manufacturerName + "." + webHookConfig.getManufacturerEventName();
        WebhookProtocolTransportObject webhookProtocolTransportObject = WebhookProtocolTransportObject.builder().cloudEventId(cloudEventId).eventType(eventType).cloudEventName(webHookConfig.getCloudEventName()).dataContentType(webHookConfig.getDataContentType()).body(body).build();
        this.webHookMQProducer.send(this.protocolAdaptor.toCloudEvent((ProtocolTransportObject)webhookProtocolTransportObject), new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                if (WebHookController.this.logger.isDebugEnabled()) {
                    WebHookController.this.logger.debug(sendResult.toString());
                }
            }

            public void onException(OnExceptionContext context) {
                WebHookController.this.logger.warn("", (Throwable)context.getException());
            }
        });
    }

    public void setConfigurationWrapper(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }
}

