/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

public class HttpResponseUtils {
    public static final HttpResponse createSuccess() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    public static final HttpResponse createNotFound() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
    }

    public static final HttpResponse createInternalServerError() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private static final ByteBuf crateByteBuf(ChannelHandlerContext ctx, String body) {
        byte[] bytes = body.getBytes();
        ByteBuf byteBuf = ctx.alloc().buffer(bytes.length);
        byteBuf.writeBytes(bytes);
        return byteBuf;
    }

    public static final HttpResponse setResponseJsonBody(String body, ChannelHandlerContext ctx) {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, HttpResponseUtils.crateByteBuf(ctx, body), (HttpHeaders)responseHeaders, (HttpHeaders)responseHeaders);
    }

    public static final HttpResponse setResponseTextBody(String body, ChannelHandlerContext ctx) {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_HTML);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, HttpResponseUtils.crateByteBuf(ctx, body), (HttpHeaders)responseHeaders, (HttpHeaders)responseHeaders);
    }
}

