/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.registry;

import java.util.List;
import java.util.Map;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static final Logger logger = LoggerFactory.getLogger(Registry.class);
    private volatile boolean inited = false;
    private volatile boolean started = false;
    private RegistryService registryService;

    public synchronized void init(String registryPluginType) throws Exception {
        if (!this.inited) {
            this.registryService = (RegistryService)EventMeshExtensionFactory.getExtension(RegistryService.class, (String)registryPluginType);
            if (this.registryService == null) {
                logger.error("can't load the registryService plugin, please check.");
                throw new RuntimeException("doesn't load the registryService plugin, please check.");
            }
            this.registryService.init();
            this.inited = true;
        }
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.registryService.start();
            this.started = true;
        }
    }

    public synchronized void shutdown() throws Exception {
        if (this.started) {
            this.registryService.shutdown();
            this.started = false;
            this.inited = false;
        }
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws Exception {
        return this.registryService.findEventMeshInfoByCluster(clusterName);
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws Exception {
        return this.registryService.findAllEventMeshInfo();
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws Exception {
        return this.registryService.findEventMeshClientDistributionData(clusterName, group, purpose);
    }

    public void registerMetadata(Map<String, String> metadata) {
        this.registryService.registerMetadata(metadata);
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws Exception {
        return this.registryService.register(eventMeshRegisterInfo);
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws Exception {
        return this.registryService.unRegister(eventMeshUnRegisterInfo);
    }
}

