/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPusher {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicLong deliveredMsgsCount = new AtomicLong(0L);
    private AtomicLong deliverFailMsgsCount = new AtomicLong(0L);
    private ConcurrentHashMap<String, DownStreamMsgContext> downStreamMap = new ConcurrentHashMap();
    private Session session;

    public SessionPusher(Session session) {
        this.session = session;
    }

    public String toString() {
        return "SessionPusher{deliveredMsgsCount=" + this.deliveredMsgsCount.longValue() + ",deliverFailCount=" + this.deliverFailMsgsCount.longValue() + ",unAckMsg=" + CollectionUtils.size(this.downStreamMap) + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void push(DownStreamMsgContext downStreamMsgContext) {
        Command cmd = SubscriptionMode.BROADCASTING.equals((Object)downStreamMsgContext.subscriptionItem.getMode()) ? Command.BROADCAST_MESSAGE_TO_CLIENT : (SubscriptionType.SYNC.equals((Object)downStreamMsgContext.subscriptionItem.getType()) ? Command.REQUEST_TO_CLIENT : Command.ASYNC_MESSAGE_TO_CLIENT);
        String protocolType = Objects.requireNonNull(downStreamMsgContext.event.getExtension("protocoltype")).toString();
        ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        Package pkg = new Package();
        downStreamMsgContext.event = CloudEventBuilder.from((CloudEvent)downStreamMsgContext.event).withExtension("reqeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rsp0sys", this.session.getClient().getSubsystem()).withExtension("rsp0group", this.session.getClient().getGroup()).withExtension("rsp0idc", this.session.getClient().getIdc()).withExtension("rsp0ip", this.session.getClient().getHost()).build();
        Object body = null;
        int retCode = 0;
        String retMsg = null;
        pkg = (Package)protocolAdaptor.fromCloudEvent(downStreamMsgContext.event);
        pkg.setHeader(new Header(cmd, OPStatus.SUCCESS.getCode().intValue(), null, downStreamMsgContext.seq));
        pkg.getHeader().putProperty("protocoltype", (Object)protocolType);
        this.messageLogger.info("pkg|mq2eventMesh|cmd={}|mqMsg={}|user={}", new Object[]{cmd, pkg, this.session.getClient()});
        ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
        String protocolVersion = Objects.requireNonNull(downStreamMsgContext.event.getSpecVersion()).toString();
        Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, downStreamMsgContext.event), "downstream-eventmesh-client-span", false);
        try {
            this.session.getContext().writeAndFlush((Object)pkg).addListener((GenericFutureListener)new ChannelFutureListener(downStreamMsgContext){
                final /* synthetic */ DownStreamMsgContext val$downStreamMsgContext;
                {
                    this.val$downStreamMsgContext = downStreamMsgContext;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SessionPusher.this.logger.error("downstreamMsg fail,seq:{}, retryTimes:{}, event:{}", new Object[]{this.val$downStreamMsgContext.seq, this.val$downStreamMsgContext.retryTimes, this.val$downStreamMsgContext.event});
                        SessionPusher.this.deliverFailMsgsCount.incrementAndGet();
                        long isolateTime = System.currentTimeMillis() + (long)((SessionPusher)SessionPusher.this).session.getEventMeshTCPConfiguration().eventMeshTcpPushFailIsolateTimeInMills;
                        SessionPusher.this.session.setIsolateTime(isolateTime);
                        SessionPusher.this.logger.warn("isolate client:{},isolateTime:{}", (Object)SessionPusher.this.session.getClient(), (Object)isolateTime);
                        long delayTime = SubscriptionType.SYNC.equals((Object)this.val$downStreamMsgContext.subscriptionItem.getType()) ? (long)((SessionPusher)SessionPusher.this).session.getEventMeshTCPConfiguration().eventMeshTcpMsgRetrySyncDelayInMills : (long)((SessionPusher)SessionPusher.this).session.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryAsyncDelayInMills;
                        this.val$downStreamMsgContext.delay(delayTime);
                        ((ClientGroupWrapper)SessionPusher.this.session.getClientGroupWrapper().get()).getEventMeshTcpRetryer().pushRetry(this.val$downStreamMsgContext);
                    } else {
                        SessionPusher.this.deliveredMsgsCount.incrementAndGet();
                        SessionPusher.this.logger.info("downstreamMsg success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{this.val$downStreamMsgContext.seq, this.val$downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(this.val$downStreamMsgContext.event)});
                        if (SessionPusher.this.session.isIsolated()) {
                            SessionPusher.this.logger.info("cancel isolated,client:{}", (Object)SessionPusher.this.session.getClient());
                            SessionPusher.this.session.setIsolateTime(System.currentTimeMillis());
                        }
                    }
                }
            });
        }
        finally {
            TraceUtils.finishSpan(span, downStreamMsgContext.event);
        }
        catch (Exception e) {
            try {
                pkg.setHeader(new Header(cmd, OPStatus.FAIL.getCode().intValue(), e.getStackTrace().toString(), downStreamMsgContext.seq));
                retCode = -1;
                retMsg = e.toString();
                ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
            }
            catch (Throwable throwable) {
                ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
                String protocolVersion2 = Objects.requireNonNull(downStreamMsgContext.event.getSpecVersion()).toString();
                Span span2 = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion2, downStreamMsgContext.event), "downstream-eventmesh-client-span", false);
                try {
                    this.session.getContext().writeAndFlush((Object)pkg).addListener((GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
                }
                finally {
                    TraceUtils.finishSpan(span2, downStreamMsgContext.event);
                }
                throw throwable;
            }
            protocolVersion = Objects.requireNonNull(downStreamMsgContext.event.getSpecVersion()).toString();
            span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, downStreamMsgContext.event), "downstream-eventmesh-client-span", false);
            try {
                this.session.getContext().writeAndFlush((Object)pkg).addListener((GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
            }
            finally {
                TraceUtils.finishSpan(span, downStreamMsgContext.event);
            }
        }
    }

    public void unAckMsg(String seq, DownStreamMsgContext downStreamMsgContext) {
        this.downStreamMap.put(seq, downStreamMsgContext);
        this.logger.info("put msg in unAckMsg,seq:{},unAckMsgSize:{}", (Object)seq, (Object)this.getTotalUnackMsgs());
    }

    public int getTotalUnackMsgs() {
        return this.downStreamMap.size();
    }

    public ConcurrentHashMap<String, DownStreamMsgContext> getUnAckMsg() {
        return this.downStreamMap;
    }

    public AtomicLong getDeliveredMsgsCount() {
        return this.deliveredMsgsCount;
    }

    public AtomicLong getDeliverFailMsgsCount() {
        return this.deliverFailMsgsCount;
    }
}

