/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendStrategy;
import org.apache.eventmesh.runtime.util.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshRecommendImpl
implements EventMeshRecommendStrategy {
    protected final Logger logger = LoggerFactory.getLogger(EventMeshRecommendImpl.class);
    private EventMeshTCPServer eventMeshTCPServer;

    public EventMeshRecommendImpl(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public String calculateRecommendEventMesh(String group, String purpose) throws Exception {
        List<EventMeshDataInfo> eventMeshDataInfoList = null;
        if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)purpose)) {
            this.logger.warn("EventMeshRecommend failed,params illegal,group:{},purpose:{}", (Object)group, (Object)purpose);
            return null;
        }
        String cluster = this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshCluster;
        try {
            eventMeshDataInfoList = this.eventMeshTCPServer.getRegistry().findEventMeshInfoByCluster(cluster);
        }
        catch (Exception e) {
            this.logger.warn("EventMeshRecommend failed, findEventMeshInfoByCluster failed, cluster:{}, group:{}, purpose:{}, errMsg:{}", new Object[]{cluster, group, purpose, e});
            return null;
        }
        if (eventMeshDataInfoList == null || CollectionUtils.isEmpty(eventMeshDataInfoList)) {
            this.logger.warn("EventMeshRecommend failed,not find eventMesh instances from registry,cluster:{},group:{},purpose:{}", new Object[]{cluster, group, purpose});
            return null;
        }
        HashMap<String, String> localEventMeshMap = new HashMap<String, String>();
        HashMap<String, String> remoteEventMeshMap = new HashMap<String, String>();
        String localIdc = this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshIDC;
        for (EventMeshDataInfo eventMeshDataInfo : eventMeshDataInfoList) {
            String idc = eventMeshDataInfo.getEventMeshName().split("-")[0];
            if (StringUtils.isNotBlank((CharSequence)idc)) {
                if (StringUtils.equals((CharSequence)idc, (CharSequence)localIdc)) {
                    localEventMeshMap.put(eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint());
                    continue;
                }
                remoteEventMeshMap.put(eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint());
                continue;
            }
            this.logger.error("EventMeshName may be illegal,idc is null,eventMeshName:{}", (Object)eventMeshDataInfo.getEventMeshName());
        }
        if (localEventMeshMap.size() == 0 && remoteEventMeshMap.size() == 0) {
            this.logger.warn("EventMeshRecommend failed,find no legal eventMesh instances from registry,localIDC:{}", (Object)localIdc);
            return null;
        }
        if (localEventMeshMap.size() > 0) {
            return this.recommendProxyByDistributeData(cluster, group, purpose, localEventMeshMap, true);
        }
        if (remoteEventMeshMap.size() > 0) {
            return this.recommendProxyByDistributeData(cluster, group, purpose, remoteEventMeshMap, false);
        }
        this.logger.error("localEventMeshMap or remoteEventMeshMap size error");
        return null;
    }

    @Override
    public List<String> calculateRedirectRecommendEventMesh(Map<String, String> eventMeshMap, Map<String, Integer> clientDistributeMap, String group, int recommendProxyNum, String eventMeshName) throws Exception {
        if (recommendProxyNum < 1) {
            return null;
        }
        this.logger.info("eventMeshMap:{},clientDistributionMap:{},group:{},recommendNum:{},currEventMeshName:{}", new Object[]{eventMeshMap, clientDistributeMap, group, recommendProxyNum, eventMeshName});
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>();
        ValueComparator vc = new ValueComparator();
        for (Map.Entry<String, Integer> entry : clientDistributeMap.entrySet()) {
            list.add(entry);
        }
        Collections.sort(list, vc);
        this.logger.info("clientDistributionMap after sort:{}", list);
        ArrayList<String> recommendProxyList = new ArrayList<String>(recommendProxyNum);
        while (recommendProxyList.size() < recommendProxyNum) {
            Map.Entry minProxyItem = (Map.Entry)list.get(0);
            int currProxyNum = clientDistributeMap.get(eventMeshName);
            recommendProxyList.add(eventMeshMap.get(minProxyItem.getKey()));
            clientDistributeMap.put((String)minProxyItem.getKey(), (Integer)minProxyItem.getValue() + 1);
            clientDistributeMap.put(eventMeshName, currProxyNum - 1);
            Collections.sort(list, vc);
            this.logger.info("clientDistributionMap after sort:{}", list);
        }
        this.logger.info("choose proxys with min instance num, group:{}, recommendProxyNum:{}, recommendProxyList:{}", new Object[]{group, recommendProxyNum, recommendProxyList});
        return recommendProxyList;
    }

    private String recommendProxyByDistributeData(String cluster, String group, String purpose, Map<String, String> eventMeshMap, boolean caculateLocal) {
        this.logger.info("eventMeshMap:{},cluster:{},group:{},purpose:{},caculateLocal:{}", new Object[]{eventMeshMap, cluster, group, purpose, caculateLocal});
        String recommendProxyAddr = null;
        ArrayList<String> tmpProxyAddrList = null;
        Map<String, Map<String, Integer>> eventMeshClientDistributionDataMap = null;
        try {
            eventMeshClientDistributionDataMap = this.eventMeshTCPServer.getRegistry().findEventMeshClientDistributionData(cluster, group, purpose);
        }
        catch (Exception e) {
            this.logger.warn("EventMeshRecommend failed,findEventMeshClientDistributionData failed,cluster:{},group:{},purpose:{}, errMsg:{}", new Object[]{cluster, group, purpose, e});
        }
        if (eventMeshClientDistributionDataMap == null || MapUtils.isEmpty(eventMeshClientDistributionDataMap)) {
            tmpProxyAddrList = new ArrayList<String>(eventMeshMap.values());
            Collections.shuffle(tmpProxyAddrList);
            recommendProxyAddr = (String)tmpProxyAddrList.get(0);
            this.logger.info("No distribute data in registry,cluster:{}, group:{},purpose:{}, recommendProxyAddr:{}", new Object[]{cluster, group, purpose, recommendProxyAddr});
            return recommendProxyAddr;
        }
        HashMap<String, Integer> localClientDistributionMap = new HashMap<String, Integer>();
        HashMap<String, Integer> remoteClientDistributionMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<String, Integer>> entry : eventMeshClientDistributionDataMap.entrySet()) {
            String idc = entry.getKey().split("-")[0];
            if (StringUtils.isNotBlank((CharSequence)idc)) {
                if (StringUtils.equals((CharSequence)idc, (CharSequence)this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshIDC)) {
                    localClientDistributionMap.put(entry.getKey(), entry.getValue().get(purpose));
                    continue;
                }
                remoteClientDistributionMap.put(entry.getKey(), entry.getValue().get(purpose));
                continue;
            }
            this.logger.error("eventMeshName may be illegal,idc is null,eventMeshName:{}", (Object)entry.getKey());
        }
        recommendProxyAddr = this.recommendProxy(eventMeshMap, caculateLocal ? localClientDistributionMap : remoteClientDistributionMap, group);
        this.logger.info("eventMeshMap:{},group:{},purpose:{},caculateLocal:{},recommendProxyAddr:{}", new Object[]{eventMeshMap, group, purpose, caculateLocal, recommendProxyAddr});
        return recommendProxyAddr;
    }

    private String recommendProxy(Map<String, String> eventMeshMap, Map<String, Integer> clientDistributionMap, String group) {
        this.logger.info("eventMeshMap:{},clientDistributionMap:{},group:{}", new Object[]{eventMeshMap, clientDistributionMap, group});
        String recommendProxy = null;
        for (String proxyName : clientDistributionMap.keySet()) {
            if (eventMeshMap.keySet().contains(proxyName)) continue;
            this.logger.warn("exist proxy not register but exist in distributionMap,proxy:{}", (Object)proxyName);
            return null;
        }
        for (String proxy : eventMeshMap.keySet()) {
            if (clientDistributionMap.keySet().contains(proxy)) continue;
            clientDistributionMap.put(proxy, 0);
        }
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>();
        ValueComparator vc = new ValueComparator();
        for (Map.Entry<String, Integer> entry : clientDistributionMap.entrySet()) {
            list.add(entry);
        }
        if (list.size() == 0) {
            this.logger.error("no legal distribute data,check eventMeshMap and distributeData, group:{}", (Object)group);
            return null;
        }
        Collections.sort(list, vc);
        this.logger.info("clientDistributionMap after sort:{}", list);
        recommendProxy = eventMeshMap.get(((Map.Entry)list.get(0)).getKey());
        return recommendProxy;
    }

    private List<String> calculate(Map<String, String> proxyMap, Map<String, Integer> clientDistributionMap, String group, int recommendProxyNum) {
        return null;
    }
}

