/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.AbstractHTTPPushRequest;
import org.apache.eventmesh.runtime.core.protocol.http.push.AsyncHTTPPushRequest;
import org.apache.eventmesh.runtime.core.protocol.http.push.MessageHandler;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMessageHandler
implements MessageHandler {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventMeshConsumer eventMeshConsumer;
    private static final ScheduledExecutorService SCHEDULER = ThreadPoolFactory.createSingleScheduledExecutor((String)"eventMesh-pushMsgTimeout-");
    private ThreadPoolExecutor pushExecutor;
    private static final Integer CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD = 10000;
    public static Map<String, Set<AbstractHTTPPushRequest>> waitingRequests = Maps.newConcurrentMap();

    private void checkTimeout() {
        waitingRequests.entrySet().stream().forEach(entry -> {
            for (AbstractHTTPPushRequest request : (Set)entry.getValue()) {
                request.timeout();
                waitingRequests.get(request.handleMsgContext.getConsumerGroup()).remove(request);
            }
        });
    }

    public HTTPMessageHandler(EventMeshConsumer eventMeshConsumer) {
        this.eventMeshConsumer = eventMeshConsumer;
        this.pushExecutor = eventMeshConsumer.getEventMeshHTTPServer().pushMsgExecutor;
        waitingRequests.put(this.eventMeshConsumer.getConsumerGroupConf().getConsumerGroup(), Sets.newConcurrentHashSet());
        SCHEDULER.scheduleAtFixedRate(this::checkTimeout, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean handle(HandleMsgContext handleMsgContext) {
        Set waitingRequests4Group = (Set)MapUtils.getObject(waitingRequests, (Object)handleMsgContext.getConsumerGroup(), (Object)Sets.newConcurrentHashSet());
        if (waitingRequests4Group.size() > CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD) {
            this.logger.warn("waitingRequests is too many, so reject, this message will be send back to MQ, consumerGroup:{}, threshold:{}", (Object)handleMsgContext.getConsumerGroup(), (Object)CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD);
            return false;
        }
        try {
            this.pushExecutor.submit(() -> {
                String protocolVersion = Objects.requireNonNull(handleMsgContext.getEvent().getSpecVersion()).toString();
                Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, handleMsgContext.getEvent()), "downstream-eventmesh-client-span", false);
                try {
                    AsyncHTTPPushRequest asyncPushRequest = new AsyncHTTPPushRequest(handleMsgContext, waitingRequests);
                    asyncPushRequest.tryHTTPRequest();
                }
                finally {
                    TraceUtils.finishSpan(span, handleMsgContext.getEvent());
                }
            });
            return true;
        }
        catch (RejectedExecutionException e) {
            this.logger.warn("pushMsgThreadPoolQueue is full, so reject, current task size {}", (Object)handleMsgContext.getEventMeshHTTPServer().getPushMsgExecutor().getQueue().size(), (Object)e);
            return false;
        }
    }
}

