/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace(isEnable=false)
public class LocalSubscribeEventProcessor
extends AbstractEventProcessor
implements AsyncHttpProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");

    public LocalSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put("ip", requestIp);
        requestWrapper.buildSysHeaderForClient();
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)sysHeaderMap.get("idc").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("pid").toString()) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("sys").toString())) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.deserialize((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String url = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = JsonUtils.serialize(requestBodyMap.get("topic"));
        List subscriptionList = (List)JsonUtils.deserialize((String)topic, (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = sysHeaderMap.get("username").toString();
            String pass = sysHeaderMap.get("passwd").toString();
            String subsystem = sysHeaderMap.get("sys").toString();
            for (SubscriptionItem item : subscriptionList) {
                try {
                    Acl.doAclCheckInHttpReceive(remoteAddr, user, pass, subsystem, item.getTopic(), requestWrapper.getRequestURI());
                }
                catch (Exception e) {
                    this.aclLogger.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_ACL_ERR, responseHeaderMap, responseBodyMap, null);
                    return;
                }
            }
        }
        try {
            if (!IPUtils.isValidDomainOrIp((String)url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv4BlackList, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv6BlackList)) {
                this.httpLogger.error("subscriber url {} is not valid", (Object)url);
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
                return;
            }
        }
        catch (Exception e) {
            this.httpLogger.error("subscriber url {} is not valid, error {}", (Object)url, (Object)e.getMessage());
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        boolean isWebhookAllowed = WebhookUtil.obtainDeliveryAgreement(this.eventMeshHTTPServer.httpClientPool.getClient(), url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshWebhookOrigin);
        if (!isWebhookAllowed) {
            this.httpLogger.error("subscriber url {} is not allowed by the target system", (Object)url);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            this.registerClient(requestWrapper, consumerGroup, subscriptionList, url);
            for (SubscriptionItem subTopic : subscriptionList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.localClientInfoMapping.get(consumerGroup + "@" + subTopic.getTopic());
                if (CollectionUtils.isEmpty(groupTopicClients)) {
                    this.httpLogger.error("group {} topic {} clients is empty", (Object)consumerGroup, (Object)subTopic);
                }
                HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                for (Client client : groupTopicClients) {
                    if (idcUrls.containsKey(client.idc)) {
                        ((List)idcUrls.get(client.idc)).add(StringUtils.deleteWhitespace((String)client.url));
                        continue;
                    }
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(client.url);
                    idcUrls.put(client.idc, urls);
                }
                ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup);
                if (consumerGroupConf == null) {
                    consumerGroupConf = new ConsumerGroupConf(consumerGroup);
                    ConsumerGroupTopicConf consumeTopicConfig = new ConsumerGroupTopicConf();
                    consumeTopicConfig.setConsumerGroup(consumerGroup);
                    consumeTopicConfig.setTopic(subTopic.getTopic());
                    consumeTopicConfig.setSubscriptionItem(subTopic);
                    consumeTopicConfig.setUrls(new HashSet<String>(Arrays.asList(url)));
                    consumeTopicConfig.setIdcUrls(idcUrls);
                    HashMap<String, ConsumerGroupTopicConf> map = new HashMap<String, ConsumerGroupTopicConf>();
                    map.put(subTopic.getTopic(), consumeTopicConfig);
                    consumerGroupConf.setConsumerGroupTopicConf(map);
                } else {
                    Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                    if (!map.containsKey(subTopic.getTopic())) {
                        ConsumerGroupTopicConf newTopicConf = new ConsumerGroupTopicConf();
                        newTopicConf.setConsumerGroup(consumerGroup);
                        newTopicConf.setTopic(subTopic.getTopic());
                        newTopicConf.setSubscriptionItem(subTopic);
                        newTopicConf.setUrls(new HashSet<String>(Arrays.asList(url)));
                        newTopicConf.setIdcUrls(idcUrls);
                        map.put(subTopic.getTopic(), newTopicConf);
                    }
                    for (String key : map.keySet()) {
                        if (!StringUtils.equals((CharSequence)subTopic.getTopic(), (CharSequence)key)) continue;
                        ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                        latestTopicConf.setConsumerGroup(consumerGroup);
                        latestTopicConf.setTopic(subTopic.getTopic());
                        latestTopicConf.setSubscriptionItem(subTopic);
                        latestTopicConf.setUrls(new HashSet<String>(Arrays.asList(url)));
                        ConsumerGroupTopicConf currentTopicConf = map.get(key);
                        latestTopicConf.getUrls().addAll(currentTopicConf.getUrls());
                        latestTopicConf.setIdcUrls(idcUrls);
                        map.put(key, latestTopicConf);
                    }
                }
                this.eventMeshHTTPServer.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
            }
            long startTime = System.currentTimeMillis();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup));
                responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
            }
            catch (Exception e) {
                long endTime = System.currentTimeMillis();
                this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)subscriptionList), url, e});
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
            }
            this.updateMetadata();
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.SUBSCRIBE_LOCAL.getRequestURI()};
    }

    private void registerClient(HttpEventWrapper requestWrapper, String consumerGroup, List<SubscriptionItem> subscriptionItems, String url) {
        Map requestHeaderMap = requestWrapper.getSysHeaderMap();
        for (SubscriptionItem item : subscriptionItems) {
            Client client = new Client();
            client.env = requestHeaderMap.get("env").toString();
            client.idc = requestHeaderMap.get("idc").toString();
            client.sys = requestHeaderMap.get("sys").toString();
            client.ip = requestHeaderMap.get("ip").toString();
            client.pid = requestHeaderMap.get("pid").toString();
            client.consumerGroup = consumerGroup;
            client.topic = item.getTopic();
            client.url = url;
            client.lastUpTime = new Date();
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (this.eventMeshHTTPServer.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)client.url)) continue;
                    isContains = true;
                    localClient.lastUpTime = client.lastUpTime;
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }
}

