/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsubscribeProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public UnsubscribeProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(Subscription subscription, EventEmitter<Response> emitter) throws Exception {
        RequestHeader header = subscription.getHeader();
        if (!ServiceUtils.validateHeader(header)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateSubscription(null, subscription)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = subscription.getConsumerGroup();
        String url = subscription.getUrl();
        List subscriptionItems = subscription.getSubscriptionItemsList();
        LinkedList<ConsumerGroupClient> removeClients = new LinkedList<ConsumerGroupClient>();
        for (Subscription.SubscriptionItem item : subscriptionItems) {
            ConsumerGroupClient newClient = ConsumerGroupClient.builder().env(header.getEnv()).idc(header.getIdc()).sys(header.getSys()).ip(header.getIp()).pid(header.getPid()).consumerGroup(consumerGroup).topic(item.getTopic()).subscriptionMode(item.getMode()).url(url).lastUpTime(new Date()).build();
            removeClients.add(newClient);
        }
        for (ConsumerGroupClient client : removeClients) {
            consumerManager.deregisterClient(client);
        }
        EventMeshConsumer eventMeshConsumer = consumerManager.getEventMeshConsumer(consumerGroup);
        boolean requireRestart = false;
        for (ConsumerGroupClient client : removeClients) {
            if (!eventMeshConsumer.deregisterClient(client)) continue;
            requireRestart = true;
        }
        if (requireRestart) {
            this.logger.info("ConsumerGroup {} topic info changed, restart EventMesh Consumer", (Object)consumerGroup);
            consumerManager.restartEventMeshConsumer(consumerGroup);
        } else {
            this.logger.warn("EventMesh consumer [{}] didn't restart.", (Object)consumerGroup);
        }
        ServiceUtils.sendRespAndDone(StatusCode.SUCCESS, "unsubscribe success", emitter);
    }
}

